// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Analysis;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Analysis.Json.IcuAnalyzerConverter))]
public sealed partial class IcuAnalyzer : Elastic.Clients.Elasticsearch.Analysis.IAnalyzer
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public IcuAnalyzer(Elastic.Clients.Elasticsearch.Analysis.IcuNormalizationType method, Elastic.Clients.Elasticsearch.Analysis.IcuNormalizationMode mode)
	{
		Method = method;
		Mode = mode;
	}
#if NET7_0_OR_GREATER
	public IcuAnalyzer()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public IcuAnalyzer()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal IcuAnalyzer(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Analysis.IcuNormalizationType Method { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Analysis.IcuNormalizationMode Mode { get; set; }

	public string Type => "icu_analyzer";
}

public readonly partial struct IcuAnalyzerDescriptor
{
	internal Elastic.Clients.Elasticsearch.Analysis.IcuAnalyzer Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public IcuAnalyzerDescriptor(Elastic.Clients.Elasticsearch.Analysis.IcuAnalyzer instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public IcuAnalyzerDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Analysis.IcuAnalyzer(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Analysis.IcuAnalyzerDescriptor(Elastic.Clients.Elasticsearch.Analysis.IcuAnalyzer instance) => new Elastic.Clients.Elasticsearch.Analysis.IcuAnalyzerDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Analysis.IcuAnalyzer(Elastic.Clients.Elasticsearch.Analysis.IcuAnalyzerDescriptor descriptor) => descriptor.Instance;

	public Elastic.Clients.Elasticsearch.Analysis.IcuAnalyzerDescriptor Method(Elastic.Clients.Elasticsearch.Analysis.IcuNormalizationType value)
	{
		Instance.Method = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.IcuAnalyzerDescriptor Mode(Elastic.Clients.Elasticsearch.Analysis.IcuNormalizationMode value)
	{
		Instance.Mode = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Analysis.IcuAnalyzer Build(System.Action<Elastic.Clients.Elasticsearch.Analysis.IcuAnalyzerDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Analysis.IcuAnalyzerDescriptor(new Elastic.Clients.Elasticsearch.Analysis.IcuAnalyzer(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}