// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Analysis;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Analysis.Json.HunspellTokenFilterConverter))]
public sealed partial class HunspellTokenFilter : Elastic.Clients.Elasticsearch.Analysis.ITokenFilter
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public HunspellTokenFilter(string locale)
	{
		Locale = locale;
	}
#if NET7_0_OR_GREATER
	public HunspellTokenFilter()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public HunspellTokenFilter()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal HunspellTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, duplicate tokens are removed from the filter’s output. Defaults to <c>true</c>.
	/// </para>
	/// </summary>
	public bool? Dedup { get; set; }

	/// <summary>
	/// <para>
	/// One or more <c>.dic</c> files (e.g, <c>en_US.dic</c>, my_custom.dic) to use for the Hunspell dictionary.
	/// By default, the <c>hunspell</c> filter uses all <c>.dic</c> files in the <c>&lt;$ES_PATH_CONF>/hunspell/&lt;locale></c> directory specified using the <c>lang</c>, <c>language</c>, or <c>locale</c> parameter.
	/// </para>
	/// </summary>
	public string? Dictionary { get; set; }

	/// <summary>
	/// <para>
	/// Locale directory used to specify the <c>.aff</c> and <c>.dic</c> files for a Hunspell dictionary.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Locale { get; set; }

	/// <summary>
	/// <para>
	/// If <c>true</c>, only the longest stemmed version of each token is included in the output. If <c>false</c>, all stemmed versions of the token are included. Defaults to <c>false</c>.
	/// </para>
	/// </summary>
	public bool? LongestOnly { get; set; }

	public string Type => "hunspell";

	public string? Version { get; set; }
}

public readonly partial struct HunspellTokenFilterDescriptor
{
	internal Elastic.Clients.Elasticsearch.Analysis.HunspellTokenFilter Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public HunspellTokenFilterDescriptor(Elastic.Clients.Elasticsearch.Analysis.HunspellTokenFilter instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public HunspellTokenFilterDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Analysis.HunspellTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Analysis.HunspellTokenFilterDescriptor(Elastic.Clients.Elasticsearch.Analysis.HunspellTokenFilter instance) => new Elastic.Clients.Elasticsearch.Analysis.HunspellTokenFilterDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Analysis.HunspellTokenFilter(Elastic.Clients.Elasticsearch.Analysis.HunspellTokenFilterDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// If <c>true</c>, duplicate tokens are removed from the filter’s output. Defaults to <c>true</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.HunspellTokenFilterDescriptor Dedup(bool? value = true)
	{
		Instance.Dedup = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// One or more <c>.dic</c> files (e.g, <c>en_US.dic</c>, my_custom.dic) to use for the Hunspell dictionary.
	/// By default, the <c>hunspell</c> filter uses all <c>.dic</c> files in the <c>&lt;$ES_PATH_CONF>/hunspell/&lt;locale></c> directory specified using the <c>lang</c>, <c>language</c>, or <c>locale</c> parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.HunspellTokenFilterDescriptor Dictionary(string? value)
	{
		Instance.Dictionary = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Locale directory used to specify the <c>.aff</c> and <c>.dic</c> files for a Hunspell dictionary.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.HunspellTokenFilterDescriptor Locale(string value)
	{
		Instance.Locale = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, only the longest stemmed version of each token is included in the output. If <c>false</c>, all stemmed versions of the token are included. Defaults to <c>false</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.HunspellTokenFilterDescriptor LongestOnly(bool? value = true)
	{
		Instance.LongestOnly = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.HunspellTokenFilterDescriptor Version(string? value)
	{
		Instance.Version = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Analysis.HunspellTokenFilter Build(System.Action<Elastic.Clients.Elasticsearch.Analysis.HunspellTokenFilterDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Analysis.HunspellTokenFilterDescriptor(new Elastic.Clients.Elasticsearch.Analysis.HunspellTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}