// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Analysis;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Analysis.Json.FingerprintTokenFilterConverter))]
public sealed partial class FingerprintTokenFilter : Elastic.Clients.Elasticsearch.Analysis.ITokenFilter
{
#if NET7_0_OR_GREATER
	public FingerprintTokenFilter()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public FingerprintTokenFilter()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal FingerprintTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Maximum character length, including whitespace, of the output token. Defaults to <c>255</c>. Concatenated tokens longer than this will result in no token output.
	/// </para>
	/// </summary>
	public int? MaxOutputSize { get; set; }

	/// <summary>
	/// <para>
	/// Character to use to concatenate the token stream input. Defaults to a space.
	/// </para>
	/// </summary>
	public string? Separator { get; set; }

	public string Type => "fingerprint";

	public string? Version { get; set; }
}

public readonly partial struct FingerprintTokenFilterDescriptor
{
	internal Elastic.Clients.Elasticsearch.Analysis.FingerprintTokenFilter Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public FingerprintTokenFilterDescriptor(Elastic.Clients.Elasticsearch.Analysis.FingerprintTokenFilter instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public FingerprintTokenFilterDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Analysis.FingerprintTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Analysis.FingerprintTokenFilterDescriptor(Elastic.Clients.Elasticsearch.Analysis.FingerprintTokenFilter instance) => new Elastic.Clients.Elasticsearch.Analysis.FingerprintTokenFilterDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Analysis.FingerprintTokenFilter(Elastic.Clients.Elasticsearch.Analysis.FingerprintTokenFilterDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Maximum character length, including whitespace, of the output token. Defaults to <c>255</c>. Concatenated tokens longer than this will result in no token output.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.FingerprintTokenFilterDescriptor MaxOutputSize(int? value)
	{
		Instance.MaxOutputSize = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Character to use to concatenate the token stream input. Defaults to a space.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.FingerprintTokenFilterDescriptor Separator(string? value)
	{
		Instance.Separator = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.FingerprintTokenFilterDescriptor Version(string? value)
	{
		Instance.Version = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Analysis.FingerprintTokenFilter Build(System.Action<Elastic.Clients.Elasticsearch.Analysis.FingerprintTokenFilterDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Analysis.FingerprintTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Analysis.FingerprintTokenFilterDescriptor(new Elastic.Clients.Elasticsearch.Analysis.FingerprintTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}