// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Analysis;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Analysis.Json.FingerprintAnalyzerConverter))]
public sealed partial class FingerprintAnalyzer : Elastic.Clients.Elasticsearch.Analysis.IAnalyzer
{
#if NET7_0_OR_GREATER
	public FingerprintAnalyzer()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public FingerprintAnalyzer()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal FingerprintAnalyzer(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The maximum token size to emit. Tokens larger than this size will be discarded.
	/// Defaults to <c>255</c>
	/// </para>
	/// </summary>
	public int? MaxOutputSize { get; set; }

	/// <summary>
	/// <para>
	/// The character to use to concatenate the terms.
	/// Defaults to a space.
	/// </para>
	/// </summary>
	public string? Separator { get; set; }

	/// <summary>
	/// <para>
	/// A pre-defined stop words list like <c>_english_</c> or an array containing a list of stop words.
	/// Defaults to <c>_none_</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Union<Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage, System.Collections.Generic.ICollection<string>>? Stopwords { get; set; }

	/// <summary>
	/// <para>
	/// The path to a file containing stop words.
	/// </para>
	/// </summary>
	public string? StopwordsPath { get; set; }

	public string Type => "fingerprint";

	[System.Obsolete("Deprecated in '7.14.0'.")]
	public string? Version { get; set; }
}

public readonly partial struct FingerprintAnalyzerDescriptor
{
	internal Elastic.Clients.Elasticsearch.Analysis.FingerprintAnalyzer Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public FingerprintAnalyzerDescriptor(Elastic.Clients.Elasticsearch.Analysis.FingerprintAnalyzer instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public FingerprintAnalyzerDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Analysis.FingerprintAnalyzer(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Analysis.FingerprintAnalyzerDescriptor(Elastic.Clients.Elasticsearch.Analysis.FingerprintAnalyzer instance) => new Elastic.Clients.Elasticsearch.Analysis.FingerprintAnalyzerDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Analysis.FingerprintAnalyzer(Elastic.Clients.Elasticsearch.Analysis.FingerprintAnalyzerDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The maximum token size to emit. Tokens larger than this size will be discarded.
	/// Defaults to <c>255</c>
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.FingerprintAnalyzerDescriptor MaxOutputSize(int? value)
	{
		Instance.MaxOutputSize = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The character to use to concatenate the terms.
	/// Defaults to a space.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.FingerprintAnalyzerDescriptor Separator(string? value)
	{
		Instance.Separator = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A pre-defined stop words list like <c>_english_</c> or an array containing a list of stop words.
	/// Defaults to <c>_none_</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.FingerprintAnalyzerDescriptor Stopwords(Elastic.Clients.Elasticsearch.Union<Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage, System.Collections.Generic.ICollection<string>>? value)
	{
		Instance.Stopwords = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The path to a file containing stop words.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.FingerprintAnalyzerDescriptor StopwordsPath(string? value)
	{
		Instance.StopwordsPath = value;
		return this;
	}

	[System.Obsolete("Deprecated in '7.14.0'.")]
	public Elastic.Clients.Elasticsearch.Analysis.FingerprintAnalyzerDescriptor Version(string? value)
	{
		Instance.Version = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Analysis.FingerprintAnalyzer Build(System.Action<Elastic.Clients.Elasticsearch.Analysis.FingerprintAnalyzerDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Analysis.FingerprintAnalyzer(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Analysis.FingerprintAnalyzerDescriptor(new Elastic.Clients.Elasticsearch.Analysis.FingerprintAnalyzer(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}