// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Analysis;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Analysis.Json.ElisionTokenFilterConverter))]
public sealed partial class ElisionTokenFilter : Elastic.Clients.Elasticsearch.Analysis.ITokenFilter
{
#if NET7_0_OR_GREATER
	public ElisionTokenFilter()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public ElisionTokenFilter()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal ElisionTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// List of elisions to remove.
	/// To be removed, the elision must be at the beginning of a token and be immediately followed by an apostrophe. Both the elision and apostrophe are removed.
	/// For custom <c>elision</c> filters, either this parameter or <c>articles_path</c> must be specified.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<string>? Articles { get; set; }

	/// <summary>
	/// <para>
	/// If <c>true</c>, elision matching is case insensitive. If <c>false</c>, elision matching is case sensitive. Defaults to <c>false</c>.
	/// </para>
	/// </summary>
	public bool? ArticlesCase { get; set; }

	/// <summary>
	/// <para>
	/// Path to a file that contains a list of elisions to remove.
	/// This path must be absolute or relative to the <c>config</c> location, and the file must be UTF-8 encoded. Each elision in the file must be separated by a line break.
	/// To be removed, the elision must be at the beginning of a token and be immediately followed by an apostrophe. Both the elision and apostrophe are removed.
	/// For custom <c>elision</c> filters, either this parameter or <c>articles</c> must be specified.
	/// </para>
	/// </summary>
	public string? ArticlesPath { get; set; }

	public string Type => "elision";

	public string? Version { get; set; }
}

public readonly partial struct ElisionTokenFilterDescriptor
{
	internal Elastic.Clients.Elasticsearch.Analysis.ElisionTokenFilter Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ElisionTokenFilterDescriptor(Elastic.Clients.Elasticsearch.Analysis.ElisionTokenFilter instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ElisionTokenFilterDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Analysis.ElisionTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Analysis.ElisionTokenFilterDescriptor(Elastic.Clients.Elasticsearch.Analysis.ElisionTokenFilter instance) => new Elastic.Clients.Elasticsearch.Analysis.ElisionTokenFilterDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Analysis.ElisionTokenFilter(Elastic.Clients.Elasticsearch.Analysis.ElisionTokenFilterDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// List of elisions to remove.
	/// To be removed, the elision must be at the beginning of a token and be immediately followed by an apostrophe. Both the elision and apostrophe are removed.
	/// For custom <c>elision</c> filters, either this parameter or <c>articles_path</c> must be specified.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.ElisionTokenFilterDescriptor Articles(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.Articles = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// List of elisions to remove.
	/// To be removed, the elision must be at the beginning of a token and be immediately followed by an apostrophe. Both the elision and apostrophe are removed.
	/// For custom <c>elision</c> filters, either this parameter or <c>articles_path</c> must be specified.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.ElisionTokenFilterDescriptor Articles(params string[] values)
	{
		Instance.Articles = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, elision matching is case insensitive. If <c>false</c>, elision matching is case sensitive. Defaults to <c>false</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.ElisionTokenFilterDescriptor ArticlesCase(bool? value = true)
	{
		Instance.ArticlesCase = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Path to a file that contains a list of elisions to remove.
	/// This path must be absolute or relative to the <c>config</c> location, and the file must be UTF-8 encoded. Each elision in the file must be separated by a line break.
	/// To be removed, the elision must be at the beginning of a token and be immediately followed by an apostrophe. Both the elision and apostrophe are removed.
	/// For custom <c>elision</c> filters, either this parameter or <c>articles</c> must be specified.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.ElisionTokenFilterDescriptor ArticlesPath(string? value)
	{
		Instance.ArticlesPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ElisionTokenFilterDescriptor Version(string? value)
	{
		Instance.Version = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Analysis.ElisionTokenFilter Build(System.Action<Elastic.Clients.Elasticsearch.Analysis.ElisionTokenFilterDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Analysis.ElisionTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Analysis.ElisionTokenFilterDescriptor(new Elastic.Clients.Elasticsearch.Analysis.ElisionTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}