// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Analysis;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Analysis.Json.EdgeNGramTokenizerConverter))]
public sealed partial class EdgeNGramTokenizer : Elastic.Clients.Elasticsearch.Analysis.ITokenizer
{
#if NET7_0_OR_GREATER
	public EdgeNGramTokenizer()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public EdgeNGramTokenizer()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal EdgeNGramTokenizer(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	public string? CustomTokenChars { get; set; }
	public int? MaxGram { get; set; }
	public int? MinGram { get; set; }
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Analysis.TokenChar>? TokenChars { get; set; }

	public string Type => "edge_ngram";

	public string? Version { get; set; }
}

public readonly partial struct EdgeNGramTokenizerDescriptor
{
	internal Elastic.Clients.Elasticsearch.Analysis.EdgeNGramTokenizer Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public EdgeNGramTokenizerDescriptor(Elastic.Clients.Elasticsearch.Analysis.EdgeNGramTokenizer instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public EdgeNGramTokenizerDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Analysis.EdgeNGramTokenizer(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Analysis.EdgeNGramTokenizerDescriptor(Elastic.Clients.Elasticsearch.Analysis.EdgeNGramTokenizer instance) => new Elastic.Clients.Elasticsearch.Analysis.EdgeNGramTokenizerDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Analysis.EdgeNGramTokenizer(Elastic.Clients.Elasticsearch.Analysis.EdgeNGramTokenizerDescriptor descriptor) => descriptor.Instance;

	public Elastic.Clients.Elasticsearch.Analysis.EdgeNGramTokenizerDescriptor CustomTokenChars(string? value)
	{
		Instance.CustomTokenChars = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.EdgeNGramTokenizerDescriptor MaxGram(int? value)
	{
		Instance.MaxGram = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.EdgeNGramTokenizerDescriptor MinGram(int? value)
	{
		Instance.MinGram = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.EdgeNGramTokenizerDescriptor TokenChars(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Analysis.TokenChar>? value)
	{
		Instance.TokenChars = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.EdgeNGramTokenizerDescriptor TokenChars(params Elastic.Clients.Elasticsearch.Analysis.TokenChar[] values)
	{
		Instance.TokenChars = [.. values];
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.EdgeNGramTokenizerDescriptor Version(string? value)
	{
		Instance.Version = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Analysis.EdgeNGramTokenizer Build(System.Action<Elastic.Clients.Elasticsearch.Analysis.EdgeNGramTokenizerDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Analysis.EdgeNGramTokenizer(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Analysis.EdgeNGramTokenizerDescriptor(new Elastic.Clients.Elasticsearch.Analysis.EdgeNGramTokenizer(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}