// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Analysis;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Analysis.Json.EdgeNGramTokenFilterConverter))]
public sealed partial class EdgeNGramTokenFilter : Elastic.Clients.Elasticsearch.Analysis.ITokenFilter
{
#if NET7_0_OR_GREATER
	public EdgeNGramTokenFilter()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public EdgeNGramTokenFilter()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal EdgeNGramTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Maximum character length of a gram. For custom token filters, defaults to <c>2</c>. For the built-in edge_ngram filter, defaults to <c>1</c>.
	/// </para>
	/// </summary>
	public int? MaxGram { get; set; }

	/// <summary>
	/// <para>
	/// Minimum character length of a gram. Defaults to <c>1</c>.
	/// </para>
	/// </summary>
	public int? MinGram { get; set; }

	/// <summary>
	/// <para>
	/// Emits original token when set to <c>true</c>. Defaults to <c>false</c>.
	/// </para>
	/// </summary>
	public bool? PreserveOriginal { get; set; }

	/// <summary>
	/// <para>
	/// Indicates whether to truncate tokens from the <c>front</c> or <c>back</c>. Defaults to <c>front</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.EdgeNGramSide? Side { get; set; }

	public string Type => "edge_ngram";

	public string? Version { get; set; }
}

public readonly partial struct EdgeNGramTokenFilterDescriptor
{
	internal Elastic.Clients.Elasticsearch.Analysis.EdgeNGramTokenFilter Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public EdgeNGramTokenFilterDescriptor(Elastic.Clients.Elasticsearch.Analysis.EdgeNGramTokenFilter instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public EdgeNGramTokenFilterDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Analysis.EdgeNGramTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Analysis.EdgeNGramTokenFilterDescriptor(Elastic.Clients.Elasticsearch.Analysis.EdgeNGramTokenFilter instance) => new Elastic.Clients.Elasticsearch.Analysis.EdgeNGramTokenFilterDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Analysis.EdgeNGramTokenFilter(Elastic.Clients.Elasticsearch.Analysis.EdgeNGramTokenFilterDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Maximum character length of a gram. For custom token filters, defaults to <c>2</c>. For the built-in edge_ngram filter, defaults to <c>1</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.EdgeNGramTokenFilterDescriptor MaxGram(int? value)
	{
		Instance.MaxGram = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Minimum character length of a gram. Defaults to <c>1</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.EdgeNGramTokenFilterDescriptor MinGram(int? value)
	{
		Instance.MinGram = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Emits original token when set to <c>true</c>. Defaults to <c>false</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.EdgeNGramTokenFilterDescriptor PreserveOriginal(bool? value = true)
	{
		Instance.PreserveOriginal = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Indicates whether to truncate tokens from the <c>front</c> or <c>back</c>. Defaults to <c>front</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.EdgeNGramTokenFilterDescriptor Side(Elastic.Clients.Elasticsearch.Analysis.EdgeNGramSide? value)
	{
		Instance.Side = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.EdgeNGramTokenFilterDescriptor Version(string? value)
	{
		Instance.Version = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Analysis.EdgeNGramTokenFilter Build(System.Action<Elastic.Clients.Elasticsearch.Analysis.EdgeNGramTokenFilterDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Analysis.EdgeNGramTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Analysis.EdgeNGramTokenFilterDescriptor(new Elastic.Clients.Elasticsearch.Analysis.EdgeNGramTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}