// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Analysis.Json;

public sealed partial class EdgeNGramSideConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Analysis.EdgeNGramSide>
{
	private static readonly System.Text.Json.JsonEncodedText MemberBack = System.Text.Json.JsonEncodedText.Encode("back");
	private static readonly System.Text.Json.JsonEncodedText MemberFront = System.Text.Json.JsonEncodedText.Encode("front");

	public override Elastic.Clients.Elasticsearch.Analysis.EdgeNGramSide Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberBack))
		{
			return Elastic.Clients.Elasticsearch.Analysis.EdgeNGramSide.Back;
		}

		if (reader.ValueTextEquals(MemberFront))
		{
			return Elastic.Clients.Elasticsearch.Analysis.EdgeNGramSide.Front;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberBack.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.EdgeNGramSide.Back;
		}

		if (string.Equals(value, MemberFront.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.EdgeNGramSide.Front;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Analysis.EdgeNGramSide)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Analysis.EdgeNGramSide value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.Analysis.EdgeNGramSide.Back:
				writer.WriteStringValue(MemberBack);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.EdgeNGramSide.Front:
				writer.WriteStringValue(MemberFront);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Analysis.EdgeNGramSide)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.Analysis.EdgeNGramSide ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Analysis.EdgeNGramSide value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}