// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Analysis;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Analysis.Json.DictionaryDecompounderTokenFilterConverter))]
public sealed partial class DictionaryDecompounderTokenFilter : Elastic.Clients.Elasticsearch.Analysis.ITokenFilter
{
#if NET7_0_OR_GREATER
	public DictionaryDecompounderTokenFilter()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public DictionaryDecompounderTokenFilter()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal DictionaryDecompounderTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Maximum subword character length. Longer subword tokens are excluded from the output. Defaults to <c>15</c>.
	/// </para>
	/// </summary>
	public int? MaxSubwordSize { get; set; }

	/// <summary>
	/// <para>
	/// Minimum subword character length. Shorter subword tokens are excluded from the output. Defaults to <c>2</c>.
	/// </para>
	/// </summary>
	public int? MinSubwordSize { get; set; }

	/// <summary>
	/// <para>
	/// Minimum word character length. Shorter word tokens are excluded from the output. Defaults to <c>5</c>.
	/// </para>
	/// </summary>
	public int? MinWordSize { get; set; }

	/// <summary>
	/// <para>
	/// If <c>true</c>, only include the longest matching subword. Defaults to <c>false</c>.
	/// </para>
	/// </summary>
	public bool? OnlyLongestMatch { get; set; }

	public string Type => "dictionary_decompounder";

	public string? Version { get; set; }

	/// <summary>
	/// <para>
	/// A list of subwords to look for in the token stream. If found, the subword is included in the token output.
	/// Either this parameter or <c>word_list_path</c> must be specified.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<string>? WordList { get; set; }

	/// <summary>
	/// <para>
	/// Path to a file that contains a list of subwords to find in the token stream. If found, the subword is included in the token output.
	/// This path must be absolute or relative to the config location, and the file must be UTF-8 encoded. Each token in the file must be separated by a line break.
	/// Either this parameter or <c>word_list</c> must be specified.
	/// </para>
	/// </summary>
	public string? WordListPath { get; set; }
}

public readonly partial struct DictionaryDecompounderTokenFilterDescriptor
{
	internal Elastic.Clients.Elasticsearch.Analysis.DictionaryDecompounderTokenFilter Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DictionaryDecompounderTokenFilterDescriptor(Elastic.Clients.Elasticsearch.Analysis.DictionaryDecompounderTokenFilter instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DictionaryDecompounderTokenFilterDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Analysis.DictionaryDecompounderTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Analysis.DictionaryDecompounderTokenFilterDescriptor(Elastic.Clients.Elasticsearch.Analysis.DictionaryDecompounderTokenFilter instance) => new Elastic.Clients.Elasticsearch.Analysis.DictionaryDecompounderTokenFilterDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Analysis.DictionaryDecompounderTokenFilter(Elastic.Clients.Elasticsearch.Analysis.DictionaryDecompounderTokenFilterDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Maximum subword character length. Longer subword tokens are excluded from the output. Defaults to <c>15</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.DictionaryDecompounderTokenFilterDescriptor MaxSubwordSize(int? value)
	{
		Instance.MaxSubwordSize = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Minimum subword character length. Shorter subword tokens are excluded from the output. Defaults to <c>2</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.DictionaryDecompounderTokenFilterDescriptor MinSubwordSize(int? value)
	{
		Instance.MinSubwordSize = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Minimum word character length. Shorter word tokens are excluded from the output. Defaults to <c>5</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.DictionaryDecompounderTokenFilterDescriptor MinWordSize(int? value)
	{
		Instance.MinWordSize = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, only include the longest matching subword. Defaults to <c>false</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.DictionaryDecompounderTokenFilterDescriptor OnlyLongestMatch(bool? value = true)
	{
		Instance.OnlyLongestMatch = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.DictionaryDecompounderTokenFilterDescriptor Version(string? value)
	{
		Instance.Version = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of subwords to look for in the token stream. If found, the subword is included in the token output.
	/// Either this parameter or <c>word_list_path</c> must be specified.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.DictionaryDecompounderTokenFilterDescriptor WordList(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.WordList = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of subwords to look for in the token stream. If found, the subword is included in the token output.
	/// Either this parameter or <c>word_list_path</c> must be specified.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.DictionaryDecompounderTokenFilterDescriptor WordList(params string[] values)
	{
		Instance.WordList = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Path to a file that contains a list of subwords to find in the token stream. If found, the subword is included in the token output.
	/// This path must be absolute or relative to the config location, and the file must be UTF-8 encoded. Each token in the file must be separated by a line break.
	/// Either this parameter or <c>word_list</c> must be specified.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.DictionaryDecompounderTokenFilterDescriptor WordListPath(string? value)
	{
		Instance.WordListPath = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Analysis.DictionaryDecompounderTokenFilter Build(System.Action<Elastic.Clients.Elasticsearch.Analysis.DictionaryDecompounderTokenFilterDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Analysis.DictionaryDecompounderTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Analysis.DictionaryDecompounderTokenFilterDescriptor(new Elastic.Clients.Elasticsearch.Analysis.DictionaryDecompounderTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}