// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Analysis.Json;

public sealed partial class DictionaryDecompounderTokenFilterConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Analysis.DictionaryDecompounderTokenFilter>
{
	private static readonly System.Text.Json.JsonEncodedText PropMaxSubwordSize = System.Text.Json.JsonEncodedText.Encode("max_subword_size");
	private static readonly System.Text.Json.JsonEncodedText PropMinSubwordSize = System.Text.Json.JsonEncodedText.Encode("min_subword_size");
	private static readonly System.Text.Json.JsonEncodedText PropMinWordSize = System.Text.Json.JsonEncodedText.Encode("min_word_size");
	private static readonly System.Text.Json.JsonEncodedText PropOnlyLongestMatch = System.Text.Json.JsonEncodedText.Encode("only_longest_match");
	private static readonly System.Text.Json.JsonEncodedText PropType = System.Text.Json.JsonEncodedText.Encode("type");
	private static readonly System.Text.Json.JsonEncodedText PropVersion = System.Text.Json.JsonEncodedText.Encode("version");
	private static readonly System.Text.Json.JsonEncodedText PropWordList = System.Text.Json.JsonEncodedText.Encode("word_list");
	private static readonly System.Text.Json.JsonEncodedText PropWordListPath = System.Text.Json.JsonEncodedText.Encode("word_list_path");

	public override Elastic.Clients.Elasticsearch.Analysis.DictionaryDecompounderTokenFilter Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<int?> propMaxSubwordSize = default;
		LocalJsonValue<int?> propMinSubwordSize = default;
		LocalJsonValue<int?> propMinWordSize = default;
		LocalJsonValue<bool?> propOnlyLongestMatch = default;
		LocalJsonValue<string?> propVersion = default;
		LocalJsonValue<System.Collections.Generic.ICollection<string>?> propWordList = default;
		LocalJsonValue<string?> propWordListPath = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propMaxSubwordSize.TryReadProperty(ref reader, options, PropMaxSubwordSize, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propMinSubwordSize.TryReadProperty(ref reader, options, PropMinSubwordSize, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propMinWordSize.TryReadProperty(ref reader, options, PropMinWordSize, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propOnlyLongestMatch.TryReadProperty(ref reader, options, PropOnlyLongestMatch, static bool? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<bool>(o)))
			{
				continue;
			}

			if (reader.ValueTextEquals(PropType))
			{
				reader.SafeSkip();
				continue;
			}

			if (propVersion.TryReadProperty(ref reader, options, PropVersion, null))
			{
				continue;
			}

			if (propWordList.TryReadProperty(ref reader, options, PropWordList, static System.Collections.Generic.ICollection<string>? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadCollectionValue<string>(o, null)))
			{
				continue;
			}

			if (propWordListPath.TryReadProperty(ref reader, options, PropWordListPath, null))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.Analysis.DictionaryDecompounderTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			MaxSubwordSize = propMaxSubwordSize.Value,
			MinSubwordSize = propMinSubwordSize.Value,
			MinWordSize = propMinWordSize.Value,
			OnlyLongestMatch = propOnlyLongestMatch.Value,
			Version = propVersion.Value,
			WordList = propWordList.Value,
			WordListPath = propWordListPath.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Analysis.DictionaryDecompounderTokenFilter value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropMaxSubwordSize, value.MaxSubwordSize, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropMinSubwordSize, value.MinSubwordSize, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropMinWordSize, value.MinWordSize, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropOnlyLongestMatch, value.OnlyLongestMatch, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, bool? v) => w.WriteNullableValue<bool>(o, v));
		writer.WriteProperty(options, PropType, value.Type, null, null);
		writer.WriteProperty(options, PropVersion, value.Version, null, null);
		writer.WriteProperty(options, PropWordList, value.WordList, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.ICollection<string>? v) => w.WriteCollectionValue<string>(o, v, null));
		writer.WriteProperty(options, PropWordListPath, value.WordListPath, null, null);
		writer.WriteEndObject();
	}
}