// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Analysis;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Analysis.Json.DelimitedPayloadTokenFilterConverter))]
public sealed partial class DelimitedPayloadTokenFilter : Elastic.Clients.Elasticsearch.Analysis.ITokenFilter
{
#if NET7_0_OR_GREATER
	public DelimitedPayloadTokenFilter()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public DelimitedPayloadTokenFilter()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal DelimitedPayloadTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Character used to separate tokens from payloads. Defaults to <c>|</c>.
	/// </para>
	/// </summary>
	public string? Delimiter { get; set; }

	/// <summary>
	/// <para>
	/// Data type for the stored payload.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.DelimitedPayloadEncoding? Encoding { get; set; }

	public string Type => "delimited_payload";

	public string? Version { get; set; }
}

public readonly partial struct DelimitedPayloadTokenFilterDescriptor
{
	internal Elastic.Clients.Elasticsearch.Analysis.DelimitedPayloadTokenFilter Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DelimitedPayloadTokenFilterDescriptor(Elastic.Clients.Elasticsearch.Analysis.DelimitedPayloadTokenFilter instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DelimitedPayloadTokenFilterDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Analysis.DelimitedPayloadTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Analysis.DelimitedPayloadTokenFilterDescriptor(Elastic.Clients.Elasticsearch.Analysis.DelimitedPayloadTokenFilter instance) => new Elastic.Clients.Elasticsearch.Analysis.DelimitedPayloadTokenFilterDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Analysis.DelimitedPayloadTokenFilter(Elastic.Clients.Elasticsearch.Analysis.DelimitedPayloadTokenFilterDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Character used to separate tokens from payloads. Defaults to <c>|</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.DelimitedPayloadTokenFilterDescriptor Delimiter(string? value)
	{
		Instance.Delimiter = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Data type for the stored payload.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.DelimitedPayloadTokenFilterDescriptor Encoding(Elastic.Clients.Elasticsearch.Analysis.DelimitedPayloadEncoding? value)
	{
		Instance.Encoding = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.DelimitedPayloadTokenFilterDescriptor Version(string? value)
	{
		Instance.Version = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Analysis.DelimitedPayloadTokenFilter Build(System.Action<Elastic.Clients.Elasticsearch.Analysis.DelimitedPayloadTokenFilterDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Analysis.DelimitedPayloadTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Analysis.DelimitedPayloadTokenFilterDescriptor(new Elastic.Clients.Elasticsearch.Analysis.DelimitedPayloadTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}