// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Analysis.Json;

public sealed partial class DelimitedPayloadEncodingConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Analysis.DelimitedPayloadEncoding>
{
	private static readonly System.Text.Json.JsonEncodedText MemberFloat = System.Text.Json.JsonEncodedText.Encode("float");
	private static readonly System.Text.Json.JsonEncodedText MemberIdentity = System.Text.Json.JsonEncodedText.Encode("identity");
	private static readonly System.Text.Json.JsonEncodedText MemberInteger = System.Text.Json.JsonEncodedText.Encode("int");

	public override Elastic.Clients.Elasticsearch.Analysis.DelimitedPayloadEncoding Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberFloat))
		{
			return Elastic.Clients.Elasticsearch.Analysis.DelimitedPayloadEncoding.Float;
		}

		if (reader.ValueTextEquals(MemberIdentity))
		{
			return Elastic.Clients.Elasticsearch.Analysis.DelimitedPayloadEncoding.Identity;
		}

		if (reader.ValueTextEquals(MemberInteger))
		{
			return Elastic.Clients.Elasticsearch.Analysis.DelimitedPayloadEncoding.Integer;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberFloat.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.DelimitedPayloadEncoding.Float;
		}

		if (string.Equals(value, MemberIdentity.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.DelimitedPayloadEncoding.Identity;
		}

		if (string.Equals(value, MemberInteger.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.DelimitedPayloadEncoding.Integer;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Analysis.DelimitedPayloadEncoding)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Analysis.DelimitedPayloadEncoding value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.Analysis.DelimitedPayloadEncoding.Float:
				writer.WriteStringValue(MemberFloat);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.DelimitedPayloadEncoding.Identity:
				writer.WriteStringValue(MemberIdentity);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.DelimitedPayloadEncoding.Integer:
				writer.WriteStringValue(MemberInteger);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Analysis.DelimitedPayloadEncoding)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.Analysis.DelimitedPayloadEncoding ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Analysis.DelimitedPayloadEncoding value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}