// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Analysis;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Analysis.Json.CustomAnalyzerConverter))]
public sealed partial class CustomAnalyzer : Elastic.Clients.Elasticsearch.Analysis.IAnalyzer
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public CustomAnalyzer(string tokenizer)
	{
		Tokenizer = tokenizer;
	}
#if NET7_0_OR_GREATER
	public CustomAnalyzer()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public CustomAnalyzer()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal CustomAnalyzer(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	public System.Collections.Generic.ICollection<string>? CharFilter { get; set; }
	public System.Collections.Generic.ICollection<string>? Filter { get; set; }
	public int? PositionIncrementGap { get; set; }
	public int? PositionOffsetGap { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Tokenizer { get; set; }

	public string Type => "custom";
}

public readonly partial struct CustomAnalyzerDescriptor
{
	internal Elastic.Clients.Elasticsearch.Analysis.CustomAnalyzer Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public CustomAnalyzerDescriptor(Elastic.Clients.Elasticsearch.Analysis.CustomAnalyzer instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public CustomAnalyzerDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Analysis.CustomAnalyzer(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Analysis.CustomAnalyzerDescriptor(Elastic.Clients.Elasticsearch.Analysis.CustomAnalyzer instance) => new Elastic.Clients.Elasticsearch.Analysis.CustomAnalyzerDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Analysis.CustomAnalyzer(Elastic.Clients.Elasticsearch.Analysis.CustomAnalyzerDescriptor descriptor) => descriptor.Instance;

	public Elastic.Clients.Elasticsearch.Analysis.CustomAnalyzerDescriptor CharFilter(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.CharFilter = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.CustomAnalyzerDescriptor CharFilter(params string[] values)
	{
		Instance.CharFilter = [.. values];
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.CustomAnalyzerDescriptor Filter(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.Filter = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.CustomAnalyzerDescriptor Filter(params string[] values)
	{
		Instance.Filter = [.. values];
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.CustomAnalyzerDescriptor PositionIncrementGap(int? value)
	{
		Instance.PositionIncrementGap = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.CustomAnalyzerDescriptor PositionOffsetGap(int? value)
	{
		Instance.PositionOffsetGap = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.CustomAnalyzerDescriptor Tokenizer(string value)
	{
		Instance.Tokenizer = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Analysis.CustomAnalyzer Build(System.Action<Elastic.Clients.Elasticsearch.Analysis.CustomAnalyzerDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Analysis.CustomAnalyzerDescriptor(new Elastic.Clients.Elasticsearch.Analysis.CustomAnalyzer(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}