// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Analysis;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Analysis.Json.CommonGramsTokenFilterConverter))]
public sealed partial class CommonGramsTokenFilter : Elastic.Clients.Elasticsearch.Analysis.ITokenFilter
{
#if NET7_0_OR_GREATER
	public CommonGramsTokenFilter()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public CommonGramsTokenFilter()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal CommonGramsTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// A list of tokens. The filter generates bigrams for these tokens.
	/// Either this or the <c>common_words_path</c> parameter is required.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<string>? CommonWords { get; set; }

	/// <summary>
	/// <para>
	/// Path to a file containing a list of tokens. The filter generates bigrams for these tokens.
	/// This path must be absolute or relative to the <c>config</c> location. The file must be UTF-8 encoded. Each token in the file must be separated by a line break.
	/// Either this or the <c>common_words</c> parameter is required.
	/// </para>
	/// </summary>
	public string? CommonWordsPath { get; set; }

	/// <summary>
	/// <para>
	/// If <c>true</c>, matches for common words matching are case-insensitive. Defaults to <c>false</c>.
	/// </para>
	/// </summary>
	public bool? IgnoreCase { get; set; }

	/// <summary>
	/// <para>
	/// If <c>true</c>, the filter excludes the following tokens from the output:
	/// </para>
	/// <list type="bullet">
	/// <item>
	/// <para>
	/// Unigrams for common words
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// Unigrams for terms followed by common words
	/// Defaults to <c>false</c>. We recommend enabling this parameter for search analyzers.
	/// </para>
	/// </item>
	/// </list>
	/// </summary>
	public bool? QueryMode { get; set; }

	public string Type => "common_grams";

	public string? Version { get; set; }
}

public readonly partial struct CommonGramsTokenFilterDescriptor
{
	internal Elastic.Clients.Elasticsearch.Analysis.CommonGramsTokenFilter Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public CommonGramsTokenFilterDescriptor(Elastic.Clients.Elasticsearch.Analysis.CommonGramsTokenFilter instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public CommonGramsTokenFilterDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Analysis.CommonGramsTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Analysis.CommonGramsTokenFilterDescriptor(Elastic.Clients.Elasticsearch.Analysis.CommonGramsTokenFilter instance) => new Elastic.Clients.Elasticsearch.Analysis.CommonGramsTokenFilterDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Analysis.CommonGramsTokenFilter(Elastic.Clients.Elasticsearch.Analysis.CommonGramsTokenFilterDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// A list of tokens. The filter generates bigrams for these tokens.
	/// Either this or the <c>common_words_path</c> parameter is required.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.CommonGramsTokenFilterDescriptor CommonWords(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.CommonWords = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of tokens. The filter generates bigrams for these tokens.
	/// Either this or the <c>common_words_path</c> parameter is required.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.CommonGramsTokenFilterDescriptor CommonWords(params string[] values)
	{
		Instance.CommonWords = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Path to a file containing a list of tokens. The filter generates bigrams for these tokens.
	/// This path must be absolute or relative to the <c>config</c> location. The file must be UTF-8 encoded. Each token in the file must be separated by a line break.
	/// Either this or the <c>common_words</c> parameter is required.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.CommonGramsTokenFilterDescriptor CommonWordsPath(string? value)
	{
		Instance.CommonWordsPath = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, matches for common words matching are case-insensitive. Defaults to <c>false</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.CommonGramsTokenFilterDescriptor IgnoreCase(bool? value = true)
	{
		Instance.IgnoreCase = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, the filter excludes the following tokens from the output:
	/// </para>
	/// <list type="bullet">
	/// <item>
	/// <para>
	/// Unigrams for common words
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// Unigrams for terms followed by common words
	/// Defaults to <c>false</c>. We recommend enabling this parameter for search analyzers.
	/// </para>
	/// </item>
	/// </list>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.CommonGramsTokenFilterDescriptor QueryMode(bool? value = true)
	{
		Instance.QueryMode = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.CommonGramsTokenFilterDescriptor Version(string? value)
	{
		Instance.Version = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Analysis.CommonGramsTokenFilter Build(System.Action<Elastic.Clients.Elasticsearch.Analysis.CommonGramsTokenFilterDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Analysis.CommonGramsTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Analysis.CommonGramsTokenFilterDescriptor(new Elastic.Clients.Elasticsearch.Analysis.CommonGramsTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}