// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Analysis;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Analysis.Json.ClassicTokenizerConverter))]
public sealed partial class ClassicTokenizer : Elastic.Clients.Elasticsearch.Analysis.ITokenizer
{
#if NET7_0_OR_GREATER
	public ClassicTokenizer()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public ClassicTokenizer()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal ClassicTokenizer(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	public int? MaxTokenLength { get; set; }

	public string Type => "classic";

	public string? Version { get; set; }
}

public readonly partial struct ClassicTokenizerDescriptor
{
	internal Elastic.Clients.Elasticsearch.Analysis.ClassicTokenizer Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ClassicTokenizerDescriptor(Elastic.Clients.Elasticsearch.Analysis.ClassicTokenizer instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ClassicTokenizerDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Analysis.ClassicTokenizer(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Analysis.ClassicTokenizerDescriptor(Elastic.Clients.Elasticsearch.Analysis.ClassicTokenizer instance) => new Elastic.Clients.Elasticsearch.Analysis.ClassicTokenizerDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Analysis.ClassicTokenizer(Elastic.Clients.Elasticsearch.Analysis.ClassicTokenizerDescriptor descriptor) => descriptor.Instance;

	public Elastic.Clients.Elasticsearch.Analysis.ClassicTokenizerDescriptor MaxTokenLength(int? value)
	{
		Instance.MaxTokenLength = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ClassicTokenizerDescriptor Version(string? value)
	{
		Instance.Version = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Analysis.ClassicTokenizer Build(System.Action<Elastic.Clients.Elasticsearch.Analysis.ClassicTokenizerDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Analysis.ClassicTokenizer(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Analysis.ClassicTokenizerDescriptor(new Elastic.Clients.Elasticsearch.Analysis.ClassicTokenizer(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}