// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Analysis;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Analysis.Json.CjkBigramTokenFilterConverter))]
public sealed partial class CjkBigramTokenFilter : Elastic.Clients.Elasticsearch.Analysis.ITokenFilter
{
#if NET7_0_OR_GREATER
	public CjkBigramTokenFilter()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public CjkBigramTokenFilter()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal CjkBigramTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Array of character scripts for which to disable bigrams.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Analysis.CjkBigramIgnoredScript>? IgnoredScripts { get; set; }

	/// <summary>
	/// <para>
	/// If <c>true</c>, emit tokens in both bigram and unigram form. If <c>false</c>, a CJK character is output in unigram form when it has no adjacent characters. Defaults to <c>false</c>.
	/// </para>
	/// </summary>
	public bool? OutputUnigrams { get; set; }

	public string Type => "cjk_bigram";

	public string? Version { get; set; }
}

public readonly partial struct CjkBigramTokenFilterDescriptor
{
	internal Elastic.Clients.Elasticsearch.Analysis.CjkBigramTokenFilter Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public CjkBigramTokenFilterDescriptor(Elastic.Clients.Elasticsearch.Analysis.CjkBigramTokenFilter instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public CjkBigramTokenFilterDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Analysis.CjkBigramTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Analysis.CjkBigramTokenFilterDescriptor(Elastic.Clients.Elasticsearch.Analysis.CjkBigramTokenFilter instance) => new Elastic.Clients.Elasticsearch.Analysis.CjkBigramTokenFilterDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Analysis.CjkBigramTokenFilter(Elastic.Clients.Elasticsearch.Analysis.CjkBigramTokenFilterDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Array of character scripts for which to disable bigrams.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.CjkBigramTokenFilterDescriptor IgnoredScripts(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Analysis.CjkBigramIgnoredScript>? value)
	{
		Instance.IgnoredScripts = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Array of character scripts for which to disable bigrams.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.CjkBigramTokenFilterDescriptor IgnoredScripts(params Elastic.Clients.Elasticsearch.Analysis.CjkBigramIgnoredScript[] values)
	{
		Instance.IgnoredScripts = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, emit tokens in both bigram and unigram form. If <c>false</c>, a CJK character is output in unigram form when it has no adjacent characters. Defaults to <c>false</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.CjkBigramTokenFilterDescriptor OutputUnigrams(bool? value = true)
	{
		Instance.OutputUnigrams = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.CjkBigramTokenFilterDescriptor Version(string? value)
	{
		Instance.Version = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Analysis.CjkBigramTokenFilter Build(System.Action<Elastic.Clients.Elasticsearch.Analysis.CjkBigramTokenFilterDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Analysis.CjkBigramTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Analysis.CjkBigramTokenFilterDescriptor(new Elastic.Clients.Elasticsearch.Analysis.CjkBigramTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}