// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Analysis.Json;

public sealed partial class CjkBigramIgnoredScriptConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Analysis.CjkBigramIgnoredScript>
{
	private static readonly System.Text.Json.JsonEncodedText MemberHan = System.Text.Json.JsonEncodedText.Encode("han");
	private static readonly System.Text.Json.JsonEncodedText MemberHangul = System.Text.Json.JsonEncodedText.Encode("hangul");
	private static readonly System.Text.Json.JsonEncodedText MemberHiragana = System.Text.Json.JsonEncodedText.Encode("hiragana");
	private static readonly System.Text.Json.JsonEncodedText MemberKatakana = System.Text.Json.JsonEncodedText.Encode("katakana");

	public override Elastic.Clients.Elasticsearch.Analysis.CjkBigramIgnoredScript Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberHan))
		{
			return Elastic.Clients.Elasticsearch.Analysis.CjkBigramIgnoredScript.Han;
		}

		if (reader.ValueTextEquals(MemberHangul))
		{
			return Elastic.Clients.Elasticsearch.Analysis.CjkBigramIgnoredScript.Hangul;
		}

		if (reader.ValueTextEquals(MemberHiragana))
		{
			return Elastic.Clients.Elasticsearch.Analysis.CjkBigramIgnoredScript.Hiragana;
		}

		if (reader.ValueTextEquals(MemberKatakana))
		{
			return Elastic.Clients.Elasticsearch.Analysis.CjkBigramIgnoredScript.Katakana;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberHan.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.CjkBigramIgnoredScript.Han;
		}

		if (string.Equals(value, MemberHangul.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.CjkBigramIgnoredScript.Hangul;
		}

		if (string.Equals(value, MemberHiragana.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.CjkBigramIgnoredScript.Hiragana;
		}

		if (string.Equals(value, MemberKatakana.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.CjkBigramIgnoredScript.Katakana;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Analysis.CjkBigramIgnoredScript)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Analysis.CjkBigramIgnoredScript value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.Analysis.CjkBigramIgnoredScript.Han:
				writer.WriteStringValue(MemberHan);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.CjkBigramIgnoredScript.Hangul:
				writer.WriteStringValue(MemberHangul);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.CjkBigramIgnoredScript.Hiragana:
				writer.WriteStringValue(MemberHiragana);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.CjkBigramIgnoredScript.Katakana:
				writer.WriteStringValue(MemberKatakana);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Analysis.CjkBigramIgnoredScript)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.Analysis.CjkBigramIgnoredScript ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Analysis.CjkBigramIgnoredScript value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}