// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Analysis;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Analysis.Json.CharGroupTokenizerConverter))]
public sealed partial class CharGroupTokenizer : Elastic.Clients.Elasticsearch.Analysis.ITokenizer
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public CharGroupTokenizer(System.Collections.Generic.ICollection<string> tokenizeOnChars)
	{
		TokenizeOnChars = tokenizeOnChars;
	}
#if NET7_0_OR_GREATER
	public CharGroupTokenizer()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public CharGroupTokenizer()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal CharGroupTokenizer(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	public int? MaxTokenLength { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.ICollection<string> TokenizeOnChars { get; set; }

	public string Type => "char_group";

	public string? Version { get; set; }
}

public readonly partial struct CharGroupTokenizerDescriptor
{
	internal Elastic.Clients.Elasticsearch.Analysis.CharGroupTokenizer Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public CharGroupTokenizerDescriptor(Elastic.Clients.Elasticsearch.Analysis.CharGroupTokenizer instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public CharGroupTokenizerDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Analysis.CharGroupTokenizer(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Analysis.CharGroupTokenizerDescriptor(Elastic.Clients.Elasticsearch.Analysis.CharGroupTokenizer instance) => new Elastic.Clients.Elasticsearch.Analysis.CharGroupTokenizerDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Analysis.CharGroupTokenizer(Elastic.Clients.Elasticsearch.Analysis.CharGroupTokenizerDescriptor descriptor) => descriptor.Instance;

	public Elastic.Clients.Elasticsearch.Analysis.CharGroupTokenizerDescriptor MaxTokenLength(int? value)
	{
		Instance.MaxTokenLength = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.CharGroupTokenizerDescriptor TokenizeOnChars(System.Collections.Generic.ICollection<string> value)
	{
		Instance.TokenizeOnChars = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.CharGroupTokenizerDescriptor TokenizeOnChars(params string[] values)
	{
		Instance.TokenizeOnChars = [.. values];
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.CharGroupTokenizerDescriptor Version(string? value)
	{
		Instance.Version = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Analysis.CharGroupTokenizer Build(System.Action<Elastic.Clients.Elasticsearch.Analysis.CharGroupTokenizerDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Analysis.CharGroupTokenizerDescriptor(new Elastic.Clients.Elasticsearch.Analysis.CharGroupTokenizer(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}