// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Analysis;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Analysis.Json.CharFiltersConverter))]
public sealed partial class CharFilters : Elastic.Clients.Elasticsearch.IsADictionary<string, Elastic.Clients.Elasticsearch.Analysis.ICharFilter>
{
	public CharFilters()
	{
	}

	public CharFilters(System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.Analysis.ICharFilter> backingDictionary) : base(backingDictionary)
	{
	}

	public void Add(string key, Elastic.Clients.Elasticsearch.Analysis.ICharFilter value) => BackingDictionary.Add(Sanitize(key), value);
	public bool TryGetCharFilter(string key, [System.Diagnostics.CodeAnalysis.NotNullWhen(returnValue: true)] out Elastic.Clients.Elasticsearch.Analysis.ICharFilter value) => BackingDictionary.TryGetValue(Sanitize(key), out value);

	public bool TryGetCharFilter<T>(string key, [System.Diagnostics.CodeAnalysis.NotNullWhen(returnValue: true)] out T? value) where T : class, ICharFilter
	{
		if (BackingDictionary.TryGetValue(Sanitize(key), out var matchedValue) && matchedValue is T finalValue)
		{
			value = finalValue;
			return true;
		}

		value = null;
		return false;
	}
}

public readonly partial struct CharFiltersDescriptor
{
	private readonly Elastic.Clients.Elasticsearch.Analysis.CharFilters _items = new();

	private Elastic.Clients.Elasticsearch.Analysis.CharFilters Value => _items;

	public CharFiltersDescriptor()
	{
	}

	public Elastic.Clients.Elasticsearch.Analysis.CharFiltersDescriptor HtmlStrip(string key, Elastic.Clients.Elasticsearch.Analysis.HtmlStripCharFilter value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.CharFiltersDescriptor HtmlStrip(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.HtmlStripCharFilterDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.CharFiltersDescriptor HtmlStrip(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.HtmlStripCharFilterDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.HtmlStripCharFilterDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.CharFiltersDescriptor IcuNormalization(string key, Elastic.Clients.Elasticsearch.Analysis.IcuNormalizationCharFilter value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.CharFiltersDescriptor IcuNormalization(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.IcuNormalizationCharFilterDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.CharFiltersDescriptor IcuNormalization(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.IcuNormalizationCharFilterDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.IcuNormalizationCharFilterDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.CharFiltersDescriptor KuromojiIterationMark(string key, Elastic.Clients.Elasticsearch.Analysis.KuromojiIterationMarkCharFilter value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.CharFiltersDescriptor KuromojiIterationMark(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.KuromojiIterationMarkCharFilterDescriptor> action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.KuromojiIterationMarkCharFilterDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.CharFiltersDescriptor Mapping(string key, Elastic.Clients.Elasticsearch.Analysis.MappingCharFilter value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.CharFiltersDescriptor Mapping(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.MappingCharFilterDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.CharFiltersDescriptor Mapping(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.MappingCharFilterDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.MappingCharFilterDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.CharFiltersDescriptor PatternReplace(string key, Elastic.Clients.Elasticsearch.Analysis.PatternReplaceCharFilter value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.CharFiltersDescriptor PatternReplace(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.PatternReplaceCharFilterDescriptor> action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.PatternReplaceCharFilterDescriptor.Build(action));
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Analysis.CharFilters Build(System.Action<Elastic.Clients.Elasticsearch.Analysis.CharFiltersDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Analysis.CharFilters();
		}

		var builder = new Elastic.Clients.Elasticsearch.Analysis.CharFiltersDescriptor();
		action.Invoke(builder);
		return builder.Value;
	}
}