// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Analysis;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Analysis.Json.AnalyzersConverter))]
public sealed partial class Analyzers : Elastic.Clients.Elasticsearch.IsADictionary<string, Elastic.Clients.Elasticsearch.Analysis.IAnalyzer>
{
	public Analyzers()
	{
	}

	public Analyzers(System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.Analysis.IAnalyzer> backingDictionary) : base(backingDictionary)
	{
	}

	public void Add(string key, Elastic.Clients.Elasticsearch.Analysis.IAnalyzer value) => BackingDictionary.Add(Sanitize(key), value);
	public bool TryGetAnalyzer(string key, [System.Diagnostics.CodeAnalysis.NotNullWhen(returnValue: true)] out Elastic.Clients.Elasticsearch.Analysis.IAnalyzer value) => BackingDictionary.TryGetValue(Sanitize(key), out value);

	public bool TryGetAnalyzer<T>(string key, [System.Diagnostics.CodeAnalysis.NotNullWhen(returnValue: true)] out T? value) where T : class, IAnalyzer
	{
		if (BackingDictionary.TryGetValue(Sanitize(key), out var matchedValue) && matchedValue is T finalValue)
		{
			value = finalValue;
			return true;
		}

		value = null;
		return false;
	}
}

public readonly partial struct AnalyzersDescriptor
{
	private readonly Elastic.Clients.Elasticsearch.Analysis.Analyzers _items = new();

	private Elastic.Clients.Elasticsearch.Analysis.Analyzers Value => _items;

	public AnalyzersDescriptor()
	{
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Arabic(string key, Elastic.Clients.Elasticsearch.Analysis.ArabicAnalyzer value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Arabic(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.ArabicAnalyzerDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Arabic(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.ArabicAnalyzerDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.ArabicAnalyzerDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Armenian(string key, Elastic.Clients.Elasticsearch.Analysis.ArmenianAnalyzer value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Armenian(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.ArmenianAnalyzerDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Armenian(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.ArmenianAnalyzerDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.ArmenianAnalyzerDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Basque(string key, Elastic.Clients.Elasticsearch.Analysis.BasqueAnalyzer value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Basque(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.BasqueAnalyzerDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Basque(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.BasqueAnalyzerDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.BasqueAnalyzerDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Bengali(string key, Elastic.Clients.Elasticsearch.Analysis.BengaliAnalyzer value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Bengali(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.BengaliAnalyzerDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Bengali(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.BengaliAnalyzerDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.BengaliAnalyzerDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Brazilian(string key, Elastic.Clients.Elasticsearch.Analysis.BrazilianAnalyzer value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Brazilian(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.BrazilianAnalyzerDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Brazilian(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.BrazilianAnalyzerDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.BrazilianAnalyzerDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Bulgarian(string key, Elastic.Clients.Elasticsearch.Analysis.BulgarianAnalyzer value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Bulgarian(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.BulgarianAnalyzerDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Bulgarian(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.BulgarianAnalyzerDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.BulgarianAnalyzerDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Catalan(string key, Elastic.Clients.Elasticsearch.Analysis.CatalanAnalyzer value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Catalan(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.CatalanAnalyzerDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Catalan(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.CatalanAnalyzerDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.CatalanAnalyzerDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Chinese(string key, Elastic.Clients.Elasticsearch.Analysis.ChineseAnalyzer value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Chinese(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.ChineseAnalyzerDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Chinese(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.ChineseAnalyzerDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.ChineseAnalyzerDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Cjk(string key, Elastic.Clients.Elasticsearch.Analysis.CjkAnalyzer value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Cjk(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.CjkAnalyzerDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Cjk(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.CjkAnalyzerDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.CjkAnalyzerDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Custom(string key, Elastic.Clients.Elasticsearch.Analysis.CustomAnalyzer value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Custom(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.CustomAnalyzerDescriptor> action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.CustomAnalyzerDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Czech(string key, Elastic.Clients.Elasticsearch.Analysis.CzechAnalyzer value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Czech(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.CzechAnalyzerDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Czech(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.CzechAnalyzerDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.CzechAnalyzerDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Danish(string key, Elastic.Clients.Elasticsearch.Analysis.DanishAnalyzer value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Danish(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.DanishAnalyzerDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Danish(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.DanishAnalyzerDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.DanishAnalyzerDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Dutch(string key, Elastic.Clients.Elasticsearch.Analysis.DutchAnalyzer value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Dutch(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.DutchAnalyzerDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Dutch(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.DutchAnalyzerDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.DutchAnalyzerDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor English(string key, Elastic.Clients.Elasticsearch.Analysis.EnglishAnalyzer value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor English(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.EnglishAnalyzerDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor English(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.EnglishAnalyzerDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.EnglishAnalyzerDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Estonian(string key, Elastic.Clients.Elasticsearch.Analysis.EstonianAnalyzer value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Estonian(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.EstonianAnalyzerDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Estonian(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.EstonianAnalyzerDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.EstonianAnalyzerDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Fingerprint(string key, Elastic.Clients.Elasticsearch.Analysis.FingerprintAnalyzer value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Fingerprint(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.FingerprintAnalyzerDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Fingerprint(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.FingerprintAnalyzerDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.FingerprintAnalyzerDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Finnish(string key, Elastic.Clients.Elasticsearch.Analysis.FinnishAnalyzer value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Finnish(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.FinnishAnalyzerDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Finnish(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.FinnishAnalyzerDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.FinnishAnalyzerDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor French(string key, Elastic.Clients.Elasticsearch.Analysis.FrenchAnalyzer value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor French(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.FrenchAnalyzerDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor French(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.FrenchAnalyzerDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.FrenchAnalyzerDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Galician(string key, Elastic.Clients.Elasticsearch.Analysis.GalicianAnalyzer value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Galician(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.GalicianAnalyzerDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Galician(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.GalicianAnalyzerDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.GalicianAnalyzerDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor German(string key, Elastic.Clients.Elasticsearch.Analysis.GermanAnalyzer value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor German(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.GermanAnalyzerDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor German(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.GermanAnalyzerDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.GermanAnalyzerDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Greek(string key, Elastic.Clients.Elasticsearch.Analysis.GreekAnalyzer value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Greek(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.GreekAnalyzerDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Greek(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.GreekAnalyzerDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.GreekAnalyzerDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Hindi(string key, Elastic.Clients.Elasticsearch.Analysis.HindiAnalyzer value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Hindi(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.HindiAnalyzerDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Hindi(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.HindiAnalyzerDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.HindiAnalyzerDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Hungarian(string key, Elastic.Clients.Elasticsearch.Analysis.HungarianAnalyzer value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Hungarian(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.HungarianAnalyzerDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Hungarian(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.HungarianAnalyzerDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.HungarianAnalyzerDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Icu(string key, Elastic.Clients.Elasticsearch.Analysis.IcuAnalyzer value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Icu(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.IcuAnalyzerDescriptor> action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.IcuAnalyzerDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Indonesian(string key, Elastic.Clients.Elasticsearch.Analysis.IndonesianAnalyzer value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Indonesian(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.IndonesianAnalyzerDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Indonesian(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.IndonesianAnalyzerDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.IndonesianAnalyzerDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Irish(string key, Elastic.Clients.Elasticsearch.Analysis.IrishAnalyzer value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Irish(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.IrishAnalyzerDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Irish(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.IrishAnalyzerDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.IrishAnalyzerDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Italian(string key, Elastic.Clients.Elasticsearch.Analysis.ItalianAnalyzer value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Italian(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.ItalianAnalyzerDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Italian(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.ItalianAnalyzerDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.ItalianAnalyzerDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Keyword(string key, Elastic.Clients.Elasticsearch.Analysis.KeywordAnalyzer value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Keyword(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.KeywordAnalyzerDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Keyword(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.KeywordAnalyzerDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.KeywordAnalyzerDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Kuromoji(string key, Elastic.Clients.Elasticsearch.Analysis.KuromojiAnalyzer value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Kuromoji(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.KuromojiAnalyzerDescriptor> action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.KuromojiAnalyzerDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Latvian(string key, Elastic.Clients.Elasticsearch.Analysis.LatvianAnalyzer value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Latvian(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.LatvianAnalyzerDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Latvian(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.LatvianAnalyzerDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.LatvianAnalyzerDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Lithuanian(string key, Elastic.Clients.Elasticsearch.Analysis.LithuanianAnalyzer value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Lithuanian(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.LithuanianAnalyzerDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Lithuanian(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.LithuanianAnalyzerDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.LithuanianAnalyzerDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Nori(string key, Elastic.Clients.Elasticsearch.Analysis.NoriAnalyzer value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Nori(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.NoriAnalyzerDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Nori(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.NoriAnalyzerDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.NoriAnalyzerDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Norwegian(string key, Elastic.Clients.Elasticsearch.Analysis.NorwegianAnalyzer value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Norwegian(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.NorwegianAnalyzerDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Norwegian(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.NorwegianAnalyzerDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.NorwegianAnalyzerDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Pattern(string key, Elastic.Clients.Elasticsearch.Analysis.PatternAnalyzer value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Pattern(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.PatternAnalyzerDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Pattern(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.PatternAnalyzerDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.PatternAnalyzerDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Persian(string key, Elastic.Clients.Elasticsearch.Analysis.PersianAnalyzer value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Persian(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.PersianAnalyzerDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Persian(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.PersianAnalyzerDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.PersianAnalyzerDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Portuguese(string key, Elastic.Clients.Elasticsearch.Analysis.PortugueseAnalyzer value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Portuguese(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.PortugueseAnalyzerDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Portuguese(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.PortugueseAnalyzerDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.PortugueseAnalyzerDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Romanian(string key, Elastic.Clients.Elasticsearch.Analysis.RomanianAnalyzer value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Romanian(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.RomanianAnalyzerDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Romanian(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.RomanianAnalyzerDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.RomanianAnalyzerDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Russian(string key, Elastic.Clients.Elasticsearch.Analysis.RussianAnalyzer value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Russian(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.RussianAnalyzerDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Russian(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.RussianAnalyzerDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.RussianAnalyzerDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Serbian(string key, Elastic.Clients.Elasticsearch.Analysis.SerbianAnalyzer value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Serbian(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.SerbianAnalyzerDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Serbian(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.SerbianAnalyzerDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.SerbianAnalyzerDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Simple(string key, Elastic.Clients.Elasticsearch.Analysis.SimpleAnalyzer value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Simple(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.SimpleAnalyzerDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Simple(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.SimpleAnalyzerDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.SimpleAnalyzerDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Snowball(string key, Elastic.Clients.Elasticsearch.Analysis.SnowballAnalyzer value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Snowball(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.SnowballAnalyzerDescriptor> action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.SnowballAnalyzerDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Sorani(string key, Elastic.Clients.Elasticsearch.Analysis.SoraniAnalyzer value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Sorani(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.SoraniAnalyzerDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Sorani(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.SoraniAnalyzerDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.SoraniAnalyzerDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Spanish(string key, Elastic.Clients.Elasticsearch.Analysis.SpanishAnalyzer value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Spanish(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.SpanishAnalyzerDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Spanish(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.SpanishAnalyzerDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.SpanishAnalyzerDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Standard(string key, Elastic.Clients.Elasticsearch.Analysis.StandardAnalyzer value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Standard(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.StandardAnalyzerDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Standard(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.StandardAnalyzerDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.StandardAnalyzerDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Stop(string key, Elastic.Clients.Elasticsearch.Analysis.StopAnalyzer value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Stop(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.StopAnalyzerDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Stop(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.StopAnalyzerDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.StopAnalyzerDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Swedish(string key, Elastic.Clients.Elasticsearch.Analysis.SwedishAnalyzer value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Swedish(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.SwedishAnalyzerDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Swedish(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.SwedishAnalyzerDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.SwedishAnalyzerDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Thai(string key, Elastic.Clients.Elasticsearch.Analysis.ThaiAnalyzer value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Thai(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.ThaiAnalyzerDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Thai(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.ThaiAnalyzerDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.ThaiAnalyzerDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Turkish(string key, Elastic.Clients.Elasticsearch.Analysis.TurkishAnalyzer value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Turkish(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.TurkishAnalyzerDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Turkish(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.TurkishAnalyzerDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.TurkishAnalyzerDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Whitespace(string key, Elastic.Clients.Elasticsearch.Analysis.WhitespaceAnalyzer value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Whitespace(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.WhitespaceAnalyzerDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor Whitespace(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.WhitespaceAnalyzerDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.WhitespaceAnalyzerDescriptor.Build(action));
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Analysis.Analyzers Build(System.Action<Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Analysis.Analyzers();
		}

		var builder = new Elastic.Clients.Elasticsearch.Analysis.AnalyzersDescriptor();
		action.Invoke(builder);
		return builder.Value;
	}
}