// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Analysis.Json;

public sealed partial class IAnalyzerConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Analysis.IAnalyzer>
{
	private static readonly System.Text.Json.JsonEncodedText PropDiscriminator = System.Text.Json.JsonEncodedText.Encode("type");

	public override Elastic.Clients.Elasticsearch.Analysis.IAnalyzer Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		var readerSnapshot = reader;
		string? discriminator = "custom";
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (reader.TryReadProperty(options, PropDiscriminator, ref discriminator, null))
			{
				break;
			}

			reader.SafeSkip();
		}

		reader = readerSnapshot;
		return discriminator switch
		{
			"arabic" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.ArabicAnalyzer>(options, null),
			"armenian" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.ArmenianAnalyzer>(options, null),
			"basque" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.BasqueAnalyzer>(options, null),
			"bengali" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.BengaliAnalyzer>(options, null),
			"brazilian" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.BrazilianAnalyzer>(options, null),
			"bulgarian" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.BulgarianAnalyzer>(options, null),
			"catalan" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.CatalanAnalyzer>(options, null),
			"chinese" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.ChineseAnalyzer>(options, null),
			"cjk" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.CjkAnalyzer>(options, null),
			"custom" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.CustomAnalyzer>(options, null),
			"czech" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.CzechAnalyzer>(options, null),
			"danish" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.DanishAnalyzer>(options, null),
			"dutch" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.DutchAnalyzer>(options, null),
			"english" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.EnglishAnalyzer>(options, null),
			"estonian" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.EstonianAnalyzer>(options, null),
			"fingerprint" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.FingerprintAnalyzer>(options, null),
			"finnish" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.FinnishAnalyzer>(options, null),
			"french" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.FrenchAnalyzer>(options, null),
			"galician" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.GalicianAnalyzer>(options, null),
			"german" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.GermanAnalyzer>(options, null),
			"greek" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.GreekAnalyzer>(options, null),
			"hindi" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.HindiAnalyzer>(options, null),
			"hungarian" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.HungarianAnalyzer>(options, null),
			"icu_analyzer" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.IcuAnalyzer>(options, null),
			"indonesian" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.IndonesianAnalyzer>(options, null),
			"irish" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.IrishAnalyzer>(options, null),
			"italian" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.ItalianAnalyzer>(options, null),
			"keyword" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.KeywordAnalyzer>(options, null),
			"kuromoji" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.KuromojiAnalyzer>(options, null),
			"latvian" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.LatvianAnalyzer>(options, null),
			"lithuanian" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.LithuanianAnalyzer>(options, null),
			"nori" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.NoriAnalyzer>(options, null),
			"norwegian" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.NorwegianAnalyzer>(options, null),
			"pattern" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.PatternAnalyzer>(options, null),
			"persian" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.PersianAnalyzer>(options, null),
			"portuguese" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.PortugueseAnalyzer>(options, null),
			"romanian" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.RomanianAnalyzer>(options, null),
			"russian" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.RussianAnalyzer>(options, null),
			"serbian" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.SerbianAnalyzer>(options, null),
			"simple" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.SimpleAnalyzer>(options, null),
			"snowball" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.SnowballAnalyzer>(options, null),
			"sorani" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.SoraniAnalyzer>(options, null),
			"spanish" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.SpanishAnalyzer>(options, null),
			"standard" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.StandardAnalyzer>(options, null),
			"stop" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.StopAnalyzer>(options, null),
			"swedish" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.SwedishAnalyzer>(options, null),
			"thai" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.ThaiAnalyzer>(options, null),
			"turkish" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.TurkishAnalyzer>(options, null),
			"whitespace" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.WhitespaceAnalyzer>(options, null),
			_ => throw new System.Text.Json.JsonException($"Variant '{discriminator}' is not supported for type '{nameof(Elastic.Clients.Elasticsearch.Analysis.IAnalyzer)}'.")
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Analysis.IAnalyzer value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value.Type)
		{
			case "arabic":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.ArabicAnalyzer)value, null);
				break;
			case "armenian":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.ArmenianAnalyzer)value, null);
				break;
			case "basque":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.BasqueAnalyzer)value, null);
				break;
			case "bengali":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.BengaliAnalyzer)value, null);
				break;
			case "brazilian":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.BrazilianAnalyzer)value, null);
				break;
			case "bulgarian":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.BulgarianAnalyzer)value, null);
				break;
			case "catalan":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.CatalanAnalyzer)value, null);
				break;
			case "chinese":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.ChineseAnalyzer)value, null);
				break;
			case "cjk":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.CjkAnalyzer)value, null);
				break;
			case "custom":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.CustomAnalyzer)value, null);
				break;
			case "czech":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.CzechAnalyzer)value, null);
				break;
			case "danish":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.DanishAnalyzer)value, null);
				break;
			case "dutch":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.DutchAnalyzer)value, null);
				break;
			case "english":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.EnglishAnalyzer)value, null);
				break;
			case "estonian":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.EstonianAnalyzer)value, null);
				break;
			case "fingerprint":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.FingerprintAnalyzer)value, null);
				break;
			case "finnish":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.FinnishAnalyzer)value, null);
				break;
			case "french":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.FrenchAnalyzer)value, null);
				break;
			case "galician":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.GalicianAnalyzer)value, null);
				break;
			case "german":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.GermanAnalyzer)value, null);
				break;
			case "greek":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.GreekAnalyzer)value, null);
				break;
			case "hindi":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.HindiAnalyzer)value, null);
				break;
			case "hungarian":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.HungarianAnalyzer)value, null);
				break;
			case "icu_analyzer":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.IcuAnalyzer)value, null);
				break;
			case "indonesian":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.IndonesianAnalyzer)value, null);
				break;
			case "irish":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.IrishAnalyzer)value, null);
				break;
			case "italian":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.ItalianAnalyzer)value, null);
				break;
			case "keyword":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.KeywordAnalyzer)value, null);
				break;
			case "kuromoji":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.KuromojiAnalyzer)value, null);
				break;
			case "latvian":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.LatvianAnalyzer)value, null);
				break;
			case "lithuanian":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.LithuanianAnalyzer)value, null);
				break;
			case "nori":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.NoriAnalyzer)value, null);
				break;
			case "norwegian":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.NorwegianAnalyzer)value, null);
				break;
			case "pattern":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.PatternAnalyzer)value, null);
				break;
			case "persian":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.PersianAnalyzer)value, null);
				break;
			case "portuguese":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.PortugueseAnalyzer)value, null);
				break;
			case "romanian":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.RomanianAnalyzer)value, null);
				break;
			case "russian":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.RussianAnalyzer)value, null);
				break;
			case "serbian":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.SerbianAnalyzer)value, null);
				break;
			case "simple":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.SimpleAnalyzer)value, null);
				break;
			case "snowball":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.SnowballAnalyzer)value, null);
				break;
			case "sorani":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.SoraniAnalyzer)value, null);
				break;
			case "spanish":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.SpanishAnalyzer)value, null);
				break;
			case "standard":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.StandardAnalyzer)value, null);
				break;
			case "stop":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.StopAnalyzer)value, null);
				break;
			case "swedish":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.SwedishAnalyzer)value, null);
				break;
			case "thai":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.ThaiAnalyzer)value, null);
				break;
			case "turkish":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.TurkishAnalyzer)value, null);
				break;
			case "whitespace":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.WhitespaceAnalyzer)value, null);
				break;
			default:
				throw new System.Text.Json.JsonException($"Variant '{value.Type}' is not supported for type '{nameof(Elastic.Clients.Elasticsearch.Analysis.IAnalyzer)}'.");
		}
	}
}