// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Aggregations;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Aggregations.Json.WeightedAverageValueConverter))]
public sealed partial class WeightedAverageValue
{
#if NET7_0_OR_GREATER
	public WeightedAverageValue()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public WeightedAverageValue()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal WeightedAverageValue(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The field from which to extract the values or weights.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Field? Field { get; set; }

	/// <summary>
	/// <para>
	/// A value or weight to use if the field is missing.
	/// </para>
	/// </summary>
	public double? Missing { get; set; }
	public Elastic.Clients.Elasticsearch.Script? Script { get; set; }
}

public readonly partial struct WeightedAverageValueDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.Aggregations.WeightedAverageValue Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public WeightedAverageValueDescriptor(Elastic.Clients.Elasticsearch.Aggregations.WeightedAverageValue instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public WeightedAverageValueDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Aggregations.WeightedAverageValue(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Aggregations.WeightedAverageValueDescriptor<TDocument>(Elastic.Clients.Elasticsearch.Aggregations.WeightedAverageValue instance) => new Elastic.Clients.Elasticsearch.Aggregations.WeightedAverageValueDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Aggregations.WeightedAverageValue(Elastic.Clients.Elasticsearch.Aggregations.WeightedAverageValueDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The field from which to extract the values or weights.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.WeightedAverageValueDescriptor<TDocument> Field(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field from which to extract the values or weights.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.WeightedAverageValueDescriptor<TDocument> Field(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A value or weight to use if the field is missing.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.WeightedAverageValueDescriptor<TDocument> Missing(double? value)
	{
		Instance.Missing = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.WeightedAverageValueDescriptor<TDocument> Script(Elastic.Clients.Elasticsearch.Script? value)
	{
		Instance.Script = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.WeightedAverageValueDescriptor<TDocument> Script()
	{
		Instance.Script = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.WeightedAverageValueDescriptor<TDocument> Script(System.Action<Elastic.Clients.Elasticsearch.ScriptDescriptor>? action)
	{
		Instance.Script = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Aggregations.WeightedAverageValue Build(System.Action<Elastic.Clients.Elasticsearch.Aggregations.WeightedAverageValueDescriptor<TDocument>>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Aggregations.WeightedAverageValue(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Aggregations.WeightedAverageValueDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.Aggregations.WeightedAverageValue(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct WeightedAverageValueDescriptor
{
	internal Elastic.Clients.Elasticsearch.Aggregations.WeightedAverageValue Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public WeightedAverageValueDescriptor(Elastic.Clients.Elasticsearch.Aggregations.WeightedAverageValue instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public WeightedAverageValueDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Aggregations.WeightedAverageValue(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Aggregations.WeightedAverageValueDescriptor(Elastic.Clients.Elasticsearch.Aggregations.WeightedAverageValue instance) => new Elastic.Clients.Elasticsearch.Aggregations.WeightedAverageValueDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Aggregations.WeightedAverageValue(Elastic.Clients.Elasticsearch.Aggregations.WeightedAverageValueDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The field from which to extract the values or weights.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.WeightedAverageValueDescriptor Field(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field from which to extract the values or weights.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.WeightedAverageValueDescriptor Field<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A value or weight to use if the field is missing.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.WeightedAverageValueDescriptor Missing(double? value)
	{
		Instance.Missing = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.WeightedAverageValueDescriptor Script(Elastic.Clients.Elasticsearch.Script? value)
	{
		Instance.Script = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.WeightedAverageValueDescriptor Script()
	{
		Instance.Script = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.WeightedAverageValueDescriptor Script(System.Action<Elastic.Clients.Elasticsearch.ScriptDescriptor>? action)
	{
		Instance.Script = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Aggregations.WeightedAverageValue Build(System.Action<Elastic.Clients.Elasticsearch.Aggregations.WeightedAverageValueDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Aggregations.WeightedAverageValue(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Aggregations.WeightedAverageValueDescriptor(new Elastic.Clients.Elasticsearch.Aggregations.WeightedAverageValue(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}