// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Aggregations;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Aggregations.Json.VariableWidthHistogramAggregationConverter))]
public sealed partial class VariableWidthHistogramAggregation
{
#if NET7_0_OR_GREATER
	public VariableWidthHistogramAggregation()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public VariableWidthHistogramAggregation()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal VariableWidthHistogramAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The target number of buckets.
	/// </para>
	/// </summary>
	public int? Buckets { get; set; }

	/// <summary>
	/// <para>
	/// The name of the field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Field? Field { get; set; }

	/// <summary>
	/// <para>
	/// Specifies the number of individual documents that will be stored in memory on a shard before the initial bucketing algorithm is run.
	/// Defaults to <c>min(10 * shard_size, 50000)</c>.
	/// </para>
	/// </summary>
	public int? InitialBuffer { get; set; }
	public Elastic.Clients.Elasticsearch.Script? Script { get; set; }

	/// <summary>
	/// <para>
	/// The number of buckets that the coordinating node will request from each shard.
	/// Defaults to <c>buckets * 50</c>.
	/// </para>
	/// </summary>
	public int? ShardSize { get; set; }
}

public readonly partial struct VariableWidthHistogramAggregationDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.Aggregations.VariableWidthHistogramAggregation Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public VariableWidthHistogramAggregationDescriptor(Elastic.Clients.Elasticsearch.Aggregations.VariableWidthHistogramAggregation instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public VariableWidthHistogramAggregationDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Aggregations.VariableWidthHistogramAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Aggregations.VariableWidthHistogramAggregationDescriptor<TDocument>(Elastic.Clients.Elasticsearch.Aggregations.VariableWidthHistogramAggregation instance) => new Elastic.Clients.Elasticsearch.Aggregations.VariableWidthHistogramAggregationDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Aggregations.VariableWidthHistogramAggregation(Elastic.Clients.Elasticsearch.Aggregations.VariableWidthHistogramAggregationDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The target number of buckets.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.VariableWidthHistogramAggregationDescriptor<TDocument> Buckets(int? value)
	{
		Instance.Buckets = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The name of the field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.VariableWidthHistogramAggregationDescriptor<TDocument> Field(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The name of the field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.VariableWidthHistogramAggregationDescriptor<TDocument> Field(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies the number of individual documents that will be stored in memory on a shard before the initial bucketing algorithm is run.
	/// Defaults to <c>min(10 * shard_size, 50000)</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.VariableWidthHistogramAggregationDescriptor<TDocument> InitialBuffer(int? value)
	{
		Instance.InitialBuffer = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.VariableWidthHistogramAggregationDescriptor<TDocument> Script(Elastic.Clients.Elasticsearch.Script? value)
	{
		Instance.Script = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.VariableWidthHistogramAggregationDescriptor<TDocument> Script()
	{
		Instance.Script = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.VariableWidthHistogramAggregationDescriptor<TDocument> Script(System.Action<Elastic.Clients.Elasticsearch.ScriptDescriptor>? action)
	{
		Instance.Script = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The number of buckets that the coordinating node will request from each shard.
	/// Defaults to <c>buckets * 50</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.VariableWidthHistogramAggregationDescriptor<TDocument> ShardSize(int? value)
	{
		Instance.ShardSize = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Aggregations.VariableWidthHistogramAggregation Build(System.Action<Elastic.Clients.Elasticsearch.Aggregations.VariableWidthHistogramAggregationDescriptor<TDocument>>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Aggregations.VariableWidthHistogramAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Aggregations.VariableWidthHistogramAggregationDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.Aggregations.VariableWidthHistogramAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct VariableWidthHistogramAggregationDescriptor
{
	internal Elastic.Clients.Elasticsearch.Aggregations.VariableWidthHistogramAggregation Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public VariableWidthHistogramAggregationDescriptor(Elastic.Clients.Elasticsearch.Aggregations.VariableWidthHistogramAggregation instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public VariableWidthHistogramAggregationDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Aggregations.VariableWidthHistogramAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Aggregations.VariableWidthHistogramAggregationDescriptor(Elastic.Clients.Elasticsearch.Aggregations.VariableWidthHistogramAggregation instance) => new Elastic.Clients.Elasticsearch.Aggregations.VariableWidthHistogramAggregationDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Aggregations.VariableWidthHistogramAggregation(Elastic.Clients.Elasticsearch.Aggregations.VariableWidthHistogramAggregationDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The target number of buckets.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.VariableWidthHistogramAggregationDescriptor Buckets(int? value)
	{
		Instance.Buckets = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The name of the field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.VariableWidthHistogramAggregationDescriptor Field(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The name of the field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.VariableWidthHistogramAggregationDescriptor Field<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies the number of individual documents that will be stored in memory on a shard before the initial bucketing algorithm is run.
	/// Defaults to <c>min(10 * shard_size, 50000)</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.VariableWidthHistogramAggregationDescriptor InitialBuffer(int? value)
	{
		Instance.InitialBuffer = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.VariableWidthHistogramAggregationDescriptor Script(Elastic.Clients.Elasticsearch.Script? value)
	{
		Instance.Script = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.VariableWidthHistogramAggregationDescriptor Script()
	{
		Instance.Script = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.VariableWidthHistogramAggregationDescriptor Script(System.Action<Elastic.Clients.Elasticsearch.ScriptDescriptor>? action)
	{
		Instance.Script = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The number of buckets that the coordinating node will request from each shard.
	/// Defaults to <c>buckets * 50</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.VariableWidthHistogramAggregationDescriptor ShardSize(int? value)
	{
		Instance.ShardSize = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Aggregations.VariableWidthHistogramAggregation Build(System.Action<Elastic.Clients.Elasticsearch.Aggregations.VariableWidthHistogramAggregationDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Aggregations.VariableWidthHistogramAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Aggregations.VariableWidthHistogramAggregationDescriptor(new Elastic.Clients.Elasticsearch.Aggregations.VariableWidthHistogramAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}