// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Aggregations.Json;

public sealed partial class ValueTypeConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Aggregations.ValueType>
{
	private static readonly System.Text.Json.JsonEncodedText MemberBoolean = System.Text.Json.JsonEncodedText.Encode("boolean");
	private static readonly System.Text.Json.JsonEncodedText MemberDate = System.Text.Json.JsonEncodedText.Encode("date");
	private static readonly System.Text.Json.JsonEncodedText MemberDateNanos = System.Text.Json.JsonEncodedText.Encode("date_nanos");
	private static readonly System.Text.Json.JsonEncodedText MemberDouble = System.Text.Json.JsonEncodedText.Encode("double");
	private static readonly System.Text.Json.JsonEncodedText MemberGeoPoint = System.Text.Json.JsonEncodedText.Encode("geo_point");
	private static readonly System.Text.Json.JsonEncodedText MemberIp = System.Text.Json.JsonEncodedText.Encode("ip");
	private static readonly System.Text.Json.JsonEncodedText MemberLong = System.Text.Json.JsonEncodedText.Encode("long");
	private static readonly System.Text.Json.JsonEncodedText MemberNumber = System.Text.Json.JsonEncodedText.Encode("number");
	private static readonly System.Text.Json.JsonEncodedText MemberNumeric = System.Text.Json.JsonEncodedText.Encode("numeric");
	private static readonly System.Text.Json.JsonEncodedText MemberString = System.Text.Json.JsonEncodedText.Encode("string");

	public override Elastic.Clients.Elasticsearch.Aggregations.ValueType Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberBoolean))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.ValueType.Boolean;
		}

		if (reader.ValueTextEquals(MemberDate))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.ValueType.Date;
		}

		if (reader.ValueTextEquals(MemberDateNanos))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.ValueType.DateNanos;
		}

		if (reader.ValueTextEquals(MemberDouble))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.ValueType.Double;
		}

		if (reader.ValueTextEquals(MemberGeoPoint))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.ValueType.GeoPoint;
		}

		if (reader.ValueTextEquals(MemberIp))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.ValueType.Ip;
		}

		if (reader.ValueTextEquals(MemberLong))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.ValueType.Long;
		}

		if (reader.ValueTextEquals(MemberNumber))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.ValueType.Number;
		}

		if (reader.ValueTextEquals(MemberNumeric))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.ValueType.Numeric;
		}

		if (reader.ValueTextEquals(MemberString))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.ValueType.String;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberBoolean.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.ValueType.Boolean;
		}

		if (string.Equals(value, MemberDate.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.ValueType.Date;
		}

		if (string.Equals(value, MemberDateNanos.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.ValueType.DateNanos;
		}

		if (string.Equals(value, MemberDouble.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.ValueType.Double;
		}

		if (string.Equals(value, MemberGeoPoint.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.ValueType.GeoPoint;
		}

		if (string.Equals(value, MemberIp.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.ValueType.Ip;
		}

		if (string.Equals(value, MemberLong.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.ValueType.Long;
		}

		if (string.Equals(value, MemberNumber.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.ValueType.Number;
		}

		if (string.Equals(value, MemberNumeric.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.ValueType.Numeric;
		}

		if (string.Equals(value, MemberString.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.ValueType.String;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Aggregations.ValueType)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Aggregations.ValueType value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.Aggregations.ValueType.Boolean:
				writer.WriteStringValue(MemberBoolean);
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.ValueType.Date:
				writer.WriteStringValue(MemberDate);
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.ValueType.DateNanos:
				writer.WriteStringValue(MemberDateNanos);
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.ValueType.Double:
				writer.WriteStringValue(MemberDouble);
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.ValueType.GeoPoint:
				writer.WriteStringValue(MemberGeoPoint);
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.ValueType.Ip:
				writer.WriteStringValue(MemberIp);
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.ValueType.Long:
				writer.WriteStringValue(MemberLong);
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.ValueType.Number:
				writer.WriteStringValue(MemberNumber);
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.ValueType.Numeric:
				writer.WriteStringValue(MemberNumeric);
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.ValueType.String:
				writer.WriteStringValue(MemberString);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Aggregations.ValueType)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.Aggregations.ValueType ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Aggregations.ValueType value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}