// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Aggregations;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Aggregations.Json.TopMetricsAggregationConverter))]
public sealed partial class TopMetricsAggregation
{
#if NET7_0_OR_GREATER
	public TopMetricsAggregation()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public TopMetricsAggregation()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal TopMetricsAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The field on which to run the aggregation.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Field? Field { get; set; }

	/// <summary>
	/// <para>
	/// The fields of the top document to return.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Aggregations.TopMetricsValue>? Metrics { get; set; }

	/// <summary>
	/// <para>
	/// The value to apply to documents that do not have a value.
	/// By default, documents without a value are ignored.
	/// </para>
	/// </summary>
	public object? Missing { get; set; }
	public Elastic.Clients.Elasticsearch.Script? Script { get; set; }

	/// <summary>
	/// <para>
	/// The number of top documents from which to return metrics.
	/// </para>
	/// </summary>
	public int? Size { get; set; }

	/// <summary>
	/// <para>
	/// The sort order of the documents.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.SortOptions>? Sort { get; set; }
}

public readonly partial struct TopMetricsAggregationDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.Aggregations.TopMetricsAggregation Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public TopMetricsAggregationDescriptor(Elastic.Clients.Elasticsearch.Aggregations.TopMetricsAggregation instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public TopMetricsAggregationDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Aggregations.TopMetricsAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Aggregations.TopMetricsAggregationDescriptor<TDocument>(Elastic.Clients.Elasticsearch.Aggregations.TopMetricsAggregation instance) => new Elastic.Clients.Elasticsearch.Aggregations.TopMetricsAggregationDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Aggregations.TopMetricsAggregation(Elastic.Clients.Elasticsearch.Aggregations.TopMetricsAggregationDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The field on which to run the aggregation.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.TopMetricsAggregationDescriptor<TDocument> Field(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field on which to run the aggregation.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.TopMetricsAggregationDescriptor<TDocument> Field(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The fields of the top document to return.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.TopMetricsAggregationDescriptor<TDocument> Metrics(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Aggregations.TopMetricsValue>? value)
	{
		Instance.Metrics = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The fields of the top document to return.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.TopMetricsAggregationDescriptor<TDocument> Metrics(params Elastic.Clients.Elasticsearch.Aggregations.TopMetricsValue[] values)
	{
		Instance.Metrics = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// The fields of the top document to return.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.TopMetricsAggregationDescriptor<TDocument> Metrics(params System.Action<Elastic.Clients.Elasticsearch.Aggregations.TopMetricsValueDescriptor<TDocument>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Aggregations.TopMetricsValue>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Aggregations.TopMetricsValueDescriptor<TDocument>.Build(action));
		}

		Instance.Metrics = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// The value to apply to documents that do not have a value.
	/// By default, documents without a value are ignored.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.TopMetricsAggregationDescriptor<TDocument> Missing(object? value)
	{
		Instance.Missing = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.TopMetricsAggregationDescriptor<TDocument> Script(Elastic.Clients.Elasticsearch.Script? value)
	{
		Instance.Script = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.TopMetricsAggregationDescriptor<TDocument> Script()
	{
		Instance.Script = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.TopMetricsAggregationDescriptor<TDocument> Script(System.Action<Elastic.Clients.Elasticsearch.ScriptDescriptor>? action)
	{
		Instance.Script = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The number of top documents from which to return metrics.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.TopMetricsAggregationDescriptor<TDocument> Size(int? value)
	{
		Instance.Size = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The sort order of the documents.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.TopMetricsAggregationDescriptor<TDocument> Sort(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.SortOptions>? value)
	{
		Instance.Sort = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The sort order of the documents.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.TopMetricsAggregationDescriptor<TDocument> Sort(params Elastic.Clients.Elasticsearch.SortOptions[] values)
	{
		Instance.Sort = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// The sort order of the documents.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.TopMetricsAggregationDescriptor<TDocument> Sort(params System.Action<Elastic.Clients.Elasticsearch.SortOptionsDescriptor<TDocument>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.SortOptions>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.SortOptionsDescriptor<TDocument>.Build(action));
		}

		Instance.Sort = items;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Aggregations.TopMetricsAggregation Build(System.Action<Elastic.Clients.Elasticsearch.Aggregations.TopMetricsAggregationDescriptor<TDocument>>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Aggregations.TopMetricsAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Aggregations.TopMetricsAggregationDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.Aggregations.TopMetricsAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct TopMetricsAggregationDescriptor
{
	internal Elastic.Clients.Elasticsearch.Aggregations.TopMetricsAggregation Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public TopMetricsAggregationDescriptor(Elastic.Clients.Elasticsearch.Aggregations.TopMetricsAggregation instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public TopMetricsAggregationDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Aggregations.TopMetricsAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Aggregations.TopMetricsAggregationDescriptor(Elastic.Clients.Elasticsearch.Aggregations.TopMetricsAggregation instance) => new Elastic.Clients.Elasticsearch.Aggregations.TopMetricsAggregationDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Aggregations.TopMetricsAggregation(Elastic.Clients.Elasticsearch.Aggregations.TopMetricsAggregationDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The field on which to run the aggregation.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.TopMetricsAggregationDescriptor Field(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field on which to run the aggregation.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.TopMetricsAggregationDescriptor Field<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The fields of the top document to return.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.TopMetricsAggregationDescriptor Metrics(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Aggregations.TopMetricsValue>? value)
	{
		Instance.Metrics = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The fields of the top document to return.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.TopMetricsAggregationDescriptor Metrics(params Elastic.Clients.Elasticsearch.Aggregations.TopMetricsValue[] values)
	{
		Instance.Metrics = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// The fields of the top document to return.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.TopMetricsAggregationDescriptor Metrics(params System.Action<Elastic.Clients.Elasticsearch.Aggregations.TopMetricsValueDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Aggregations.TopMetricsValue>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Aggregations.TopMetricsValueDescriptor.Build(action));
		}

		Instance.Metrics = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// The fields of the top document to return.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.TopMetricsAggregationDescriptor Metrics<T>(params System.Action<Elastic.Clients.Elasticsearch.Aggregations.TopMetricsValueDescriptor<T>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Aggregations.TopMetricsValue>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Aggregations.TopMetricsValueDescriptor<T>.Build(action));
		}

		Instance.Metrics = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// The value to apply to documents that do not have a value.
	/// By default, documents without a value are ignored.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.TopMetricsAggregationDescriptor Missing(object? value)
	{
		Instance.Missing = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.TopMetricsAggregationDescriptor Script(Elastic.Clients.Elasticsearch.Script? value)
	{
		Instance.Script = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.TopMetricsAggregationDescriptor Script()
	{
		Instance.Script = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.TopMetricsAggregationDescriptor Script(System.Action<Elastic.Clients.Elasticsearch.ScriptDescriptor>? action)
	{
		Instance.Script = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The number of top documents from which to return metrics.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.TopMetricsAggregationDescriptor Size(int? value)
	{
		Instance.Size = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The sort order of the documents.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.TopMetricsAggregationDescriptor Sort(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.SortOptions>? value)
	{
		Instance.Sort = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The sort order of the documents.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.TopMetricsAggregationDescriptor Sort(params Elastic.Clients.Elasticsearch.SortOptions[] values)
	{
		Instance.Sort = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// The sort order of the documents.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.TopMetricsAggregationDescriptor Sort(params System.Action<Elastic.Clients.Elasticsearch.SortOptionsDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.SortOptions>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.SortOptionsDescriptor.Build(action));
		}

		Instance.Sort = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// The sort order of the documents.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.TopMetricsAggregationDescriptor Sort<T>(params System.Action<Elastic.Clients.Elasticsearch.SortOptionsDescriptor<T>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.SortOptions>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.SortOptionsDescriptor<T>.Build(action));
		}

		Instance.Sort = items;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Aggregations.TopMetricsAggregation Build(System.Action<Elastic.Clients.Elasticsearch.Aggregations.TopMetricsAggregationDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Aggregations.TopMetricsAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Aggregations.TopMetricsAggregationDescriptor(new Elastic.Clients.Elasticsearch.Aggregations.TopMetricsAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}