// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Aggregations;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Aggregations.Json.TimeSeriesAggregationConverter))]
public sealed partial class TimeSeriesAggregation
{
#if NET7_0_OR_GREATER
	public TimeSeriesAggregation()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public TimeSeriesAggregation()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal TimeSeriesAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Set to <c>true</c> to associate a unique string key with each bucket and returns the ranges as a hash rather than an array.
	/// </para>
	/// </summary>
	public bool? Keyed { get; set; }

	/// <summary>
	/// <para>
	/// The maximum number of results to return.
	/// </para>
	/// </summary>
	public int? Size { get; set; }
}

public readonly partial struct TimeSeriesAggregationDescriptor
{
	internal Elastic.Clients.Elasticsearch.Aggregations.TimeSeriesAggregation Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public TimeSeriesAggregationDescriptor(Elastic.Clients.Elasticsearch.Aggregations.TimeSeriesAggregation instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public TimeSeriesAggregationDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Aggregations.TimeSeriesAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Aggregations.TimeSeriesAggregationDescriptor(Elastic.Clients.Elasticsearch.Aggregations.TimeSeriesAggregation instance) => new Elastic.Clients.Elasticsearch.Aggregations.TimeSeriesAggregationDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Aggregations.TimeSeriesAggregation(Elastic.Clients.Elasticsearch.Aggregations.TimeSeriesAggregationDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Set to <c>true</c> to associate a unique string key with each bucket and returns the ranges as a hash rather than an array.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.TimeSeriesAggregationDescriptor Keyed(bool? value = true)
	{
		Instance.Keyed = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The maximum number of results to return.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.TimeSeriesAggregationDescriptor Size(int? value)
	{
		Instance.Size = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Aggregations.TimeSeriesAggregation Build(System.Action<Elastic.Clients.Elasticsearch.Aggregations.TimeSeriesAggregationDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Aggregations.TimeSeriesAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Aggregations.TimeSeriesAggregationDescriptor(new Elastic.Clients.Elasticsearch.Aggregations.TimeSeriesAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}