// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Aggregations.Json;

public sealed partial class TermsAggregationExecutionHintConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationExecutionHint>
{
	private static readonly System.Text.Json.JsonEncodedText MemberGlobalOrdinals = System.Text.Json.JsonEncodedText.Encode("global_ordinals");
	private static readonly System.Text.Json.JsonEncodedText MemberGlobalOrdinalsHash = System.Text.Json.JsonEncodedText.Encode("global_ordinals_hash");
	private static readonly System.Text.Json.JsonEncodedText MemberGlobalOrdinalsLowCardinality = System.Text.Json.JsonEncodedText.Encode("global_ordinals_low_cardinality");
	private static readonly System.Text.Json.JsonEncodedText MemberMap = System.Text.Json.JsonEncodedText.Encode("map");

	public override Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationExecutionHint Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberGlobalOrdinals))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationExecutionHint.GlobalOrdinals;
		}

		if (reader.ValueTextEquals(MemberGlobalOrdinalsHash))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationExecutionHint.GlobalOrdinalsHash;
		}

		if (reader.ValueTextEquals(MemberGlobalOrdinalsLowCardinality))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationExecutionHint.GlobalOrdinalsLowCardinality;
		}

		if (reader.ValueTextEquals(MemberMap))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationExecutionHint.Map;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberGlobalOrdinals.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationExecutionHint.GlobalOrdinals;
		}

		if (string.Equals(value, MemberGlobalOrdinalsHash.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationExecutionHint.GlobalOrdinalsHash;
		}

		if (string.Equals(value, MemberGlobalOrdinalsLowCardinality.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationExecutionHint.GlobalOrdinalsLowCardinality;
		}

		if (string.Equals(value, MemberMap.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationExecutionHint.Map;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationExecutionHint)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationExecutionHint value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationExecutionHint.GlobalOrdinals:
				writer.WriteStringValue(MemberGlobalOrdinals);
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationExecutionHint.GlobalOrdinalsHash:
				writer.WriteStringValue(MemberGlobalOrdinalsHash);
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationExecutionHint.GlobalOrdinalsLowCardinality:
				writer.WriteStringValue(MemberGlobalOrdinalsLowCardinality);
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationExecutionHint.Map:
				writer.WriteStringValue(MemberMap);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationExecutionHint)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationExecutionHint ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationExecutionHint value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}