// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Aggregations.Json;

public sealed partial class TermsAggregationCollectModeConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationCollectMode>
{
	private static readonly System.Text.Json.JsonEncodedText MemberBreadthFirst = System.Text.Json.JsonEncodedText.Encode("breadth_first");
	private static readonly System.Text.Json.JsonEncodedText MemberDepthFirst = System.Text.Json.JsonEncodedText.Encode("depth_first");

	public override Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationCollectMode Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberBreadthFirst))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationCollectMode.BreadthFirst;
		}

		if (reader.ValueTextEquals(MemberDepthFirst))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationCollectMode.DepthFirst;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberBreadthFirst.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationCollectMode.BreadthFirst;
		}

		if (string.Equals(value, MemberDepthFirst.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationCollectMode.DepthFirst;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationCollectMode)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationCollectMode value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationCollectMode.BreadthFirst:
				writer.WriteStringValue(MemberBreadthFirst);
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationCollectMode.DepthFirst:
				writer.WriteStringValue(MemberDepthFirst);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationCollectMode)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationCollectMode ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationCollectMode value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}