// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Aggregations;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Aggregations.Json.TermsAggregationConverter))]
public sealed partial class TermsAggregation
{
#if NET7_0_OR_GREATER
	public TermsAggregation()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public TermsAggregation()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal TermsAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Determines how child aggregations should be calculated: breadth-first or depth-first.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationCollectMode? CollectMode { get; set; }

	/// <summary>
	/// <para>
	/// Values to exclude.
	/// Accepts regular expressions and partitions.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.TermsExclude? Exclude { get; set; }

	/// <summary>
	/// <para>
	/// Determines whether the aggregation will use field values directly or global ordinals.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationExecutionHint? ExecutionHint { get; set; }

	/// <summary>
	/// <para>
	/// The field from which to return terms.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Field? Field { get; set; }
	public string? Format { get; set; }

	/// <summary>
	/// <para>
	/// Values to include.
	/// Accepts regular expressions and partitions.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.TermsInclude? Include { get; set; }

	/// <summary>
	/// <para>
	/// Only return values that are found in more than <c>min_doc_count</c> hits.
	/// </para>
	/// </summary>
	public int? MinDocCount { get; set; }

	/// <summary>
	/// <para>
	/// The value to apply to documents that do not have a value.
	/// By default, documents without a value are ignored.
	/// </para>
	/// </summary>
	public object? Missing { get; set; }
	public bool? MissingBucket { get; set; }
	public Elastic.Clients.Elasticsearch.Aggregations.MissingOrder? MissingOrder { get; set; }

	/// <summary>
	/// <para>
	/// Specifies the sort order of the buckets.
	/// Defaults to sorting by descending document count.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.SortOrder>>? Order { get; set; }
	public Elastic.Clients.Elasticsearch.Script? Script { get; set; }

	/// <summary>
	/// <para>
	/// Regulates the certainty a shard has if the term should actually be added to the candidate list or not with respect to the <c>min_doc_count</c>.
	/// Terms will only be considered if their local shard frequency within the set is higher than the <c>shard_min_doc_count</c>.
	/// </para>
	/// </summary>
	public long? ShardMinDocCount { get; set; }

	/// <summary>
	/// <para>
	/// The number of candidate terms produced by each shard.
	/// By default, <c>shard_size</c> will be automatically estimated based on the number of shards and the <c>size</c> parameter.
	/// </para>
	/// </summary>
	public int? ShardSize { get; set; }

	/// <summary>
	/// <para>
	/// Set to <c>true</c> to return the <c>doc_count_error_upper_bound</c>, which is an upper bound to the error on the <c>doc_count</c> returned by each shard.
	/// </para>
	/// </summary>
	public bool? ShowTermDocCountError { get; set; }

	/// <summary>
	/// <para>
	/// The number of buckets returned out of the overall terms list.
	/// </para>
	/// </summary>
	public int? Size { get; set; }

	/// <summary>
	/// <para>
	/// Coerced unmapped fields into the specified type.
	/// </para>
	/// </summary>
	public string? ValueType { get; set; }
}

public readonly partial struct TermsAggregationDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.Aggregations.TermsAggregation Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public TermsAggregationDescriptor(Elastic.Clients.Elasticsearch.Aggregations.TermsAggregation instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public TermsAggregationDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Aggregations.TermsAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationDescriptor<TDocument>(Elastic.Clients.Elasticsearch.Aggregations.TermsAggregation instance) => new Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Aggregations.TermsAggregation(Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Determines how child aggregations should be calculated: breadth-first or depth-first.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationDescriptor<TDocument> CollectMode(Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationCollectMode? value)
	{
		Instance.CollectMode = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Values to exclude.
	/// Accepts regular expressions and partitions.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationDescriptor<TDocument> Exclude(Elastic.Clients.Elasticsearch.Aggregations.TermsExclude? value)
	{
		Instance.Exclude = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Determines whether the aggregation will use field values directly or global ordinals.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationDescriptor<TDocument> ExecutionHint(Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationExecutionHint? value)
	{
		Instance.ExecutionHint = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field from which to return terms.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationDescriptor<TDocument> Field(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field from which to return terms.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationDescriptor<TDocument> Field(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationDescriptor<TDocument> Format(string? value)
	{
		Instance.Format = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Values to include.
	/// Accepts regular expressions and partitions.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationDescriptor<TDocument> Include(Elastic.Clients.Elasticsearch.Aggregations.TermsInclude? value)
	{
		Instance.Include = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Only return values that are found in more than <c>min_doc_count</c> hits.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationDescriptor<TDocument> MinDocCount(int? value)
	{
		Instance.MinDocCount = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The value to apply to documents that do not have a value.
	/// By default, documents without a value are ignored.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationDescriptor<TDocument> Missing(object? value)
	{
		Instance.Missing = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationDescriptor<TDocument> MissingBucket(bool? value = true)
	{
		Instance.MissingBucket = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationDescriptor<TDocument> MissingOrder(Elastic.Clients.Elasticsearch.Aggregations.MissingOrder? value)
	{
		Instance.MissingOrder = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies the sort order of the buckets.
	/// Defaults to sorting by descending document count.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationDescriptor<TDocument> Order(System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.SortOrder>>? value)
	{
		Instance.Order = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies the sort order of the buckets.
	/// Defaults to sorting by descending document count.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationDescriptor<TDocument> Order()
	{
		Instance.Order = Elastic.Clients.Elasticsearch.Fluent.FluentCollectionOfKeyValuePairOfFieldSortOrder<TDocument>.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies the sort order of the buckets.
	/// Defaults to sorting by descending document count.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationDescriptor<TDocument> Order(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentCollectionOfKeyValuePairOfFieldSortOrder<TDocument>>? action)
	{
		Instance.Order = Elastic.Clients.Elasticsearch.Fluent.FluentCollectionOfKeyValuePairOfFieldSortOrder<TDocument>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationDescriptor<TDocument> AddOrder(Elastic.Clients.Elasticsearch.Field key, Elastic.Clients.Elasticsearch.SortOrder value)
	{
		Instance.Order ??= new System.Collections.Generic.List<System.Collections.Generic.KeyValuePair<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.SortOrder>>();
		Instance.Order.Add(new System.Collections.Generic.KeyValuePair<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.SortOrder>(key, value));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationDescriptor<TDocument> AddOrder(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, Elastic.Clients.Elasticsearch.SortOrder value)
	{
		Instance.Order ??= new System.Collections.Generic.List<System.Collections.Generic.KeyValuePair<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.SortOrder>>();
		Instance.Order.Add(new System.Collections.Generic.KeyValuePair<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.SortOrder>(key, value));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationDescriptor<TDocument> Script(Elastic.Clients.Elasticsearch.Script? value)
	{
		Instance.Script = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationDescriptor<TDocument> Script()
	{
		Instance.Script = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationDescriptor<TDocument> Script(System.Action<Elastic.Clients.Elasticsearch.ScriptDescriptor>? action)
	{
		Instance.Script = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Regulates the certainty a shard has if the term should actually be added to the candidate list or not with respect to the <c>min_doc_count</c>.
	/// Terms will only be considered if their local shard frequency within the set is higher than the <c>shard_min_doc_count</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationDescriptor<TDocument> ShardMinDocCount(long? value)
	{
		Instance.ShardMinDocCount = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The number of candidate terms produced by each shard.
	/// By default, <c>shard_size</c> will be automatically estimated based on the number of shards and the <c>size</c> parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationDescriptor<TDocument> ShardSize(int? value)
	{
		Instance.ShardSize = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Set to <c>true</c> to return the <c>doc_count_error_upper_bound</c>, which is an upper bound to the error on the <c>doc_count</c> returned by each shard.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationDescriptor<TDocument> ShowTermDocCountError(bool? value = true)
	{
		Instance.ShowTermDocCountError = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The number of buckets returned out of the overall terms list.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationDescriptor<TDocument> Size(int? value)
	{
		Instance.Size = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Coerced unmapped fields into the specified type.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationDescriptor<TDocument> ValueType(string? value)
	{
		Instance.ValueType = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Aggregations.TermsAggregation Build(System.Action<Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationDescriptor<TDocument>>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Aggregations.TermsAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.Aggregations.TermsAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct TermsAggregationDescriptor
{
	internal Elastic.Clients.Elasticsearch.Aggregations.TermsAggregation Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public TermsAggregationDescriptor(Elastic.Clients.Elasticsearch.Aggregations.TermsAggregation instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public TermsAggregationDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Aggregations.TermsAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationDescriptor(Elastic.Clients.Elasticsearch.Aggregations.TermsAggregation instance) => new Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Aggregations.TermsAggregation(Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Determines how child aggregations should be calculated: breadth-first or depth-first.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationDescriptor CollectMode(Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationCollectMode? value)
	{
		Instance.CollectMode = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Values to exclude.
	/// Accepts regular expressions and partitions.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationDescriptor Exclude(Elastic.Clients.Elasticsearch.Aggregations.TermsExclude? value)
	{
		Instance.Exclude = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Determines whether the aggregation will use field values directly or global ordinals.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationDescriptor ExecutionHint(Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationExecutionHint? value)
	{
		Instance.ExecutionHint = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field from which to return terms.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationDescriptor Field(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field from which to return terms.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationDescriptor Field<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationDescriptor Format(string? value)
	{
		Instance.Format = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Values to include.
	/// Accepts regular expressions and partitions.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationDescriptor Include(Elastic.Clients.Elasticsearch.Aggregations.TermsInclude? value)
	{
		Instance.Include = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Only return values that are found in more than <c>min_doc_count</c> hits.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationDescriptor MinDocCount(int? value)
	{
		Instance.MinDocCount = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The value to apply to documents that do not have a value.
	/// By default, documents without a value are ignored.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationDescriptor Missing(object? value)
	{
		Instance.Missing = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationDescriptor MissingBucket(bool? value = true)
	{
		Instance.MissingBucket = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationDescriptor MissingOrder(Elastic.Clients.Elasticsearch.Aggregations.MissingOrder? value)
	{
		Instance.MissingOrder = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies the sort order of the buckets.
	/// Defaults to sorting by descending document count.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationDescriptor Order(System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.SortOrder>>? value)
	{
		Instance.Order = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies the sort order of the buckets.
	/// Defaults to sorting by descending document count.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationDescriptor Order()
	{
		Instance.Order = Elastic.Clients.Elasticsearch.Fluent.FluentCollectionOfKeyValuePairOfFieldSortOrder.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies the sort order of the buckets.
	/// Defaults to sorting by descending document count.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationDescriptor Order(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentCollectionOfKeyValuePairOfFieldSortOrder>? action)
	{
		Instance.Order = Elastic.Clients.Elasticsearch.Fluent.FluentCollectionOfKeyValuePairOfFieldSortOrder.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies the sort order of the buckets.
	/// Defaults to sorting by descending document count.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationDescriptor Order<T>(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentCollectionOfKeyValuePairOfFieldSortOrder<T>>? action)
	{
		Instance.Order = Elastic.Clients.Elasticsearch.Fluent.FluentCollectionOfKeyValuePairOfFieldSortOrder<T>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationDescriptor AddOrder(Elastic.Clients.Elasticsearch.Field key, Elastic.Clients.Elasticsearch.SortOrder value)
	{
		Instance.Order ??= new System.Collections.Generic.List<System.Collections.Generic.KeyValuePair<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.SortOrder>>();
		Instance.Order.Add(new System.Collections.Generic.KeyValuePair<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.SortOrder>(key, value));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationDescriptor AddOrder<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, Elastic.Clients.Elasticsearch.SortOrder value)
	{
		Instance.Order ??= new System.Collections.Generic.List<System.Collections.Generic.KeyValuePair<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.SortOrder>>();
		Instance.Order.Add(new System.Collections.Generic.KeyValuePair<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.SortOrder>(key, value));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationDescriptor Script(Elastic.Clients.Elasticsearch.Script? value)
	{
		Instance.Script = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationDescriptor Script()
	{
		Instance.Script = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationDescriptor Script(System.Action<Elastic.Clients.Elasticsearch.ScriptDescriptor>? action)
	{
		Instance.Script = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Regulates the certainty a shard has if the term should actually be added to the candidate list or not with respect to the <c>min_doc_count</c>.
	/// Terms will only be considered if their local shard frequency within the set is higher than the <c>shard_min_doc_count</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationDescriptor ShardMinDocCount(long? value)
	{
		Instance.ShardMinDocCount = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The number of candidate terms produced by each shard.
	/// By default, <c>shard_size</c> will be automatically estimated based on the number of shards and the <c>size</c> parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationDescriptor ShardSize(int? value)
	{
		Instance.ShardSize = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Set to <c>true</c> to return the <c>doc_count_error_upper_bound</c>, which is an upper bound to the error on the <c>doc_count</c> returned by each shard.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationDescriptor ShowTermDocCountError(bool? value = true)
	{
		Instance.ShowTermDocCountError = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The number of buckets returned out of the overall terms list.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationDescriptor Size(int? value)
	{
		Instance.Size = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Coerced unmapped fields into the specified type.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationDescriptor ValueType(string? value)
	{
		Instance.ValueType = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Aggregations.TermsAggregation Build(System.Action<Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Aggregations.TermsAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationDescriptor(new Elastic.Clients.Elasticsearch.Aggregations.TermsAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}