// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Aggregations.Json;

public sealed partial class TTestTypeConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Aggregations.TTestType>
{
	private static readonly System.Text.Json.JsonEncodedText MemberHeteroscedastic = System.Text.Json.JsonEncodedText.Encode("heteroscedastic");
	private static readonly System.Text.Json.JsonEncodedText MemberHomoscedastic = System.Text.Json.JsonEncodedText.Encode("homoscedastic");
	private static readonly System.Text.Json.JsonEncodedText MemberPaired = System.Text.Json.JsonEncodedText.Encode("paired");

	public override Elastic.Clients.Elasticsearch.Aggregations.TTestType Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberHeteroscedastic))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.TTestType.Heteroscedastic;
		}

		if (reader.ValueTextEquals(MemberHomoscedastic))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.TTestType.Homoscedastic;
		}

		if (reader.ValueTextEquals(MemberPaired))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.TTestType.Paired;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberHeteroscedastic.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.TTestType.Heteroscedastic;
		}

		if (string.Equals(value, MemberHomoscedastic.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.TTestType.Homoscedastic;
		}

		if (string.Equals(value, MemberPaired.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.TTestType.Paired;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Aggregations.TTestType)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Aggregations.TTestType value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.Aggregations.TTestType.Heteroscedastic:
				writer.WriteStringValue(MemberHeteroscedastic);
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.TTestType.Homoscedastic:
				writer.WriteStringValue(MemberHomoscedastic);
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.TTestType.Paired:
				writer.WriteStringValue(MemberPaired);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Aggregations.TTestType)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.Aggregations.TTestType ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Aggregations.TTestType value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}