// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Aggregations;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Aggregations.Json.TTestAggregationConverter))]
public sealed partial class TTestAggregation
{
#if NET7_0_OR_GREATER
	public TTestAggregation()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public TTestAggregation()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal TTestAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Test population A.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.TestPopulation? A { get; set; }

	/// <summary>
	/// <para>
	/// Test population B.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.TestPopulation? B { get; set; }

	/// <summary>
	/// <para>
	/// The type of test.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.TTestType? Type { get; set; }
}

public readonly partial struct TTestAggregationDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.Aggregations.TTestAggregation Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public TTestAggregationDescriptor(Elastic.Clients.Elasticsearch.Aggregations.TTestAggregation instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public TTestAggregationDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Aggregations.TTestAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Aggregations.TTestAggregationDescriptor<TDocument>(Elastic.Clients.Elasticsearch.Aggregations.TTestAggregation instance) => new Elastic.Clients.Elasticsearch.Aggregations.TTestAggregationDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Aggregations.TTestAggregation(Elastic.Clients.Elasticsearch.Aggregations.TTestAggregationDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Test population A.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.TTestAggregationDescriptor<TDocument> A(Elastic.Clients.Elasticsearch.Aggregations.TestPopulation? value)
	{
		Instance.A = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Test population A.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.TTestAggregationDescriptor<TDocument> A(System.Action<Elastic.Clients.Elasticsearch.Aggregations.TestPopulationDescriptor<TDocument>> action)
	{
		Instance.A = Elastic.Clients.Elasticsearch.Aggregations.TestPopulationDescriptor<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Test population B.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.TTestAggregationDescriptor<TDocument> B(Elastic.Clients.Elasticsearch.Aggregations.TestPopulation? value)
	{
		Instance.B = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Test population B.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.TTestAggregationDescriptor<TDocument> B(System.Action<Elastic.Clients.Elasticsearch.Aggregations.TestPopulationDescriptor<TDocument>> action)
	{
		Instance.B = Elastic.Clients.Elasticsearch.Aggregations.TestPopulationDescriptor<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The type of test.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.TTestAggregationDescriptor<TDocument> Type(Elastic.Clients.Elasticsearch.Aggregations.TTestType? value)
	{
		Instance.Type = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Aggregations.TTestAggregation Build(System.Action<Elastic.Clients.Elasticsearch.Aggregations.TTestAggregationDescriptor<TDocument>>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Aggregations.TTestAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Aggregations.TTestAggregationDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.Aggregations.TTestAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct TTestAggregationDescriptor
{
	internal Elastic.Clients.Elasticsearch.Aggregations.TTestAggregation Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public TTestAggregationDescriptor(Elastic.Clients.Elasticsearch.Aggregations.TTestAggregation instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public TTestAggregationDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Aggregations.TTestAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Aggregations.TTestAggregationDescriptor(Elastic.Clients.Elasticsearch.Aggregations.TTestAggregation instance) => new Elastic.Clients.Elasticsearch.Aggregations.TTestAggregationDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Aggregations.TTestAggregation(Elastic.Clients.Elasticsearch.Aggregations.TTestAggregationDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Test population A.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.TTestAggregationDescriptor A(Elastic.Clients.Elasticsearch.Aggregations.TestPopulation? value)
	{
		Instance.A = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Test population A.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.TTestAggregationDescriptor A(System.Action<Elastic.Clients.Elasticsearch.Aggregations.TestPopulationDescriptor> action)
	{
		Instance.A = Elastic.Clients.Elasticsearch.Aggregations.TestPopulationDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Test population A.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.TTestAggregationDescriptor A<T>(System.Action<Elastic.Clients.Elasticsearch.Aggregations.TestPopulationDescriptor<T>> action)
	{
		Instance.A = Elastic.Clients.Elasticsearch.Aggregations.TestPopulationDescriptor<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Test population B.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.TTestAggregationDescriptor B(Elastic.Clients.Elasticsearch.Aggregations.TestPopulation? value)
	{
		Instance.B = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Test population B.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.TTestAggregationDescriptor B(System.Action<Elastic.Clients.Elasticsearch.Aggregations.TestPopulationDescriptor> action)
	{
		Instance.B = Elastic.Clients.Elasticsearch.Aggregations.TestPopulationDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Test population B.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.TTestAggregationDescriptor B<T>(System.Action<Elastic.Clients.Elasticsearch.Aggregations.TestPopulationDescriptor<T>> action)
	{
		Instance.B = Elastic.Clients.Elasticsearch.Aggregations.TestPopulationDescriptor<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The type of test.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.TTestAggregationDescriptor Type(Elastic.Clients.Elasticsearch.Aggregations.TTestType? value)
	{
		Instance.Type = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Aggregations.TTestAggregation Build(System.Action<Elastic.Clients.Elasticsearch.Aggregations.TTestAggregationDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Aggregations.TTestAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Aggregations.TTestAggregationDescriptor(new Elastic.Clients.Elasticsearch.Aggregations.TTestAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}