// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Aggregations.Json;

public sealed partial class TDigestExecutionHintConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Aggregations.TDigestExecutionHint>
{
	private static readonly System.Text.Json.JsonEncodedText MemberDefault = System.Text.Json.JsonEncodedText.Encode("default");
	private static readonly System.Text.Json.JsonEncodedText MemberHighAccuracy = System.Text.Json.JsonEncodedText.Encode("high_accuracy");

	public override Elastic.Clients.Elasticsearch.Aggregations.TDigestExecutionHint Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberDefault))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.TDigestExecutionHint.Default;
		}

		if (reader.ValueTextEquals(MemberHighAccuracy))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.TDigestExecutionHint.HighAccuracy;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberDefault.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.TDigestExecutionHint.Default;
		}

		if (string.Equals(value, MemberHighAccuracy.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.TDigestExecutionHint.HighAccuracy;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Aggregations.TDigestExecutionHint)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Aggregations.TDigestExecutionHint value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.Aggregations.TDigestExecutionHint.Default:
				writer.WriteStringValue(MemberDefault);
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.TDigestExecutionHint.HighAccuracy:
				writer.WriteStringValue(MemberHighAccuracy);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Aggregations.TDigestExecutionHint)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.Aggregations.TDigestExecutionHint ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Aggregations.TDigestExecutionHint value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}