// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Aggregations;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Aggregations.Json.TDigestConverter))]
public sealed partial class TDigest
{
#if NET7_0_OR_GREATER
	public TDigest()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public TDigest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal TDigest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Limits the maximum number of nodes used by the underlying TDigest algorithm to <c>20 * compression</c>, enabling control of memory usage and approximation error.
	/// </para>
	/// </summary>
	public int? Compression { get; set; }

	/// <summary>
	/// <para>
	/// The default implementation of TDigest is optimized for performance, scaling to millions or even billions of sample values while maintaining acceptable accuracy levels (close to 1% relative error for millions of samples in some cases).
	/// To use an implementation optimized for accuracy, set this parameter to high_accuracy instead.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.TDigestExecutionHint? ExecutionHint { get; set; }
}

public readonly partial struct TDigestDescriptor
{
	internal Elastic.Clients.Elasticsearch.Aggregations.TDigest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public TDigestDescriptor(Elastic.Clients.Elasticsearch.Aggregations.TDigest instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public TDigestDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Aggregations.TDigest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Aggregations.TDigestDescriptor(Elastic.Clients.Elasticsearch.Aggregations.TDigest instance) => new Elastic.Clients.Elasticsearch.Aggregations.TDigestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Aggregations.TDigest(Elastic.Clients.Elasticsearch.Aggregations.TDigestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Limits the maximum number of nodes used by the underlying TDigest algorithm to <c>20 * compression</c>, enabling control of memory usage and approximation error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.TDigestDescriptor Compression(int? value)
	{
		Instance.Compression = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The default implementation of TDigest is optimized for performance, scaling to millions or even billions of sample values while maintaining acceptable accuracy levels (close to 1% relative error for millions of samples in some cases).
	/// To use an implementation optimized for accuracy, set this parameter to high_accuracy instead.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.TDigestDescriptor ExecutionHint(Elastic.Clients.Elasticsearch.Aggregations.TDigestExecutionHint? value)
	{
		Instance.ExecutionHint = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Aggregations.TDigest Build(System.Action<Elastic.Clients.Elasticsearch.Aggregations.TDigestDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Aggregations.TDigest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Aggregations.TDigestDescriptor(new Elastic.Clients.Elasticsearch.Aggregations.TDigest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}