// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Aggregations;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Aggregations.Json.ScriptedMetricAggregationConverter))]
public sealed partial class ScriptedMetricAggregation
{
#if NET7_0_OR_GREATER
	public ScriptedMetricAggregation()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public ScriptedMetricAggregation()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal ScriptedMetricAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Runs once on each shard after document collection is complete.
	/// Allows the aggregation to consolidate the state returned from each shard.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Script? CombineScript { get; set; }

	/// <summary>
	/// <para>
	/// The field on which to run the aggregation.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Field? Field { get; set; }

	/// <summary>
	/// <para>
	/// Runs prior to any collection of documents.
	/// Allows the aggregation to set up any initial state.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Script? InitScript { get; set; }

	/// <summary>
	/// <para>
	/// Run once per document collected.
	/// If no <c>combine_script</c> is specified, the resulting state needs to be stored in the <c>state</c> object.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Script? MapScript { get; set; }

	/// <summary>
	/// <para>
	/// The value to apply to documents that do not have a value.
	/// By default, documents without a value are ignored.
	/// </para>
	/// </summary>
	public object? Missing { get; set; }

	/// <summary>
	/// <para>
	/// A global object with script parameters for <c>init</c>, <c>map</c> and <c>combine</c> scripts.
	/// It is shared between the scripts.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IDictionary<string, object>? Params { get; set; }

	/// <summary>
	/// <para>
	/// Runs once on the coordinating node after all shards have returned their results.
	/// The script is provided with access to a variable <c>states</c>, which is an array of the result of the <c>combine_script</c> on each shard.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Script? ReduceScript { get; set; }
	public Elastic.Clients.Elasticsearch.Script? Script { get; set; }
}

public readonly partial struct ScriptedMetricAggregationDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.Aggregations.ScriptedMetricAggregation Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ScriptedMetricAggregationDescriptor(Elastic.Clients.Elasticsearch.Aggregations.ScriptedMetricAggregation instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ScriptedMetricAggregationDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Aggregations.ScriptedMetricAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Aggregations.ScriptedMetricAggregationDescriptor<TDocument>(Elastic.Clients.Elasticsearch.Aggregations.ScriptedMetricAggregation instance) => new Elastic.Clients.Elasticsearch.Aggregations.ScriptedMetricAggregationDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Aggregations.ScriptedMetricAggregation(Elastic.Clients.Elasticsearch.Aggregations.ScriptedMetricAggregationDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Runs once on each shard after document collection is complete.
	/// Allows the aggregation to consolidate the state returned from each shard.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.ScriptedMetricAggregationDescriptor<TDocument> CombineScript(Elastic.Clients.Elasticsearch.Script? value)
	{
		Instance.CombineScript = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Runs once on each shard after document collection is complete.
	/// Allows the aggregation to consolidate the state returned from each shard.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.ScriptedMetricAggregationDescriptor<TDocument> CombineScript()
	{
		Instance.CombineScript = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Runs once on each shard after document collection is complete.
	/// Allows the aggregation to consolidate the state returned from each shard.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.ScriptedMetricAggregationDescriptor<TDocument> CombineScript(System.Action<Elastic.Clients.Elasticsearch.ScriptDescriptor>? action)
	{
		Instance.CombineScript = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The field on which to run the aggregation.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.ScriptedMetricAggregationDescriptor<TDocument> Field(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field on which to run the aggregation.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.ScriptedMetricAggregationDescriptor<TDocument> Field(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Runs prior to any collection of documents.
	/// Allows the aggregation to set up any initial state.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.ScriptedMetricAggregationDescriptor<TDocument> InitScript(Elastic.Clients.Elasticsearch.Script? value)
	{
		Instance.InitScript = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Runs prior to any collection of documents.
	/// Allows the aggregation to set up any initial state.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.ScriptedMetricAggregationDescriptor<TDocument> InitScript()
	{
		Instance.InitScript = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Runs prior to any collection of documents.
	/// Allows the aggregation to set up any initial state.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.ScriptedMetricAggregationDescriptor<TDocument> InitScript(System.Action<Elastic.Clients.Elasticsearch.ScriptDescriptor>? action)
	{
		Instance.InitScript = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Run once per document collected.
	/// If no <c>combine_script</c> is specified, the resulting state needs to be stored in the <c>state</c> object.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.ScriptedMetricAggregationDescriptor<TDocument> MapScript(Elastic.Clients.Elasticsearch.Script? value)
	{
		Instance.MapScript = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Run once per document collected.
	/// If no <c>combine_script</c> is specified, the resulting state needs to be stored in the <c>state</c> object.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.ScriptedMetricAggregationDescriptor<TDocument> MapScript()
	{
		Instance.MapScript = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Run once per document collected.
	/// If no <c>combine_script</c> is specified, the resulting state needs to be stored in the <c>state</c> object.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.ScriptedMetricAggregationDescriptor<TDocument> MapScript(System.Action<Elastic.Clients.Elasticsearch.ScriptDescriptor>? action)
	{
		Instance.MapScript = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The value to apply to documents that do not have a value.
	/// By default, documents without a value are ignored.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.ScriptedMetricAggregationDescriptor<TDocument> Missing(object? value)
	{
		Instance.Missing = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A global object with script parameters for <c>init</c>, <c>map</c> and <c>combine</c> scripts.
	/// It is shared between the scripts.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.ScriptedMetricAggregationDescriptor<TDocument> Params(System.Collections.Generic.IDictionary<string, object>? value)
	{
		Instance.Params = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A global object with script parameters for <c>init</c>, <c>map</c> and <c>combine</c> scripts.
	/// It is shared between the scripts.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.ScriptedMetricAggregationDescriptor<TDocument> Params()
	{
		Instance.Params = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// A global object with script parameters for <c>init</c>, <c>map</c> and <c>combine</c> scripts.
	/// It is shared between the scripts.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.ScriptedMetricAggregationDescriptor<TDocument> Params(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject>? action)
	{
		Instance.Params = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.ScriptedMetricAggregationDescriptor<TDocument> AddParam(string key, object value)
	{
		Instance.Params ??= new System.Collections.Generic.Dictionary<string, object>();
		Instance.Params.Add(key, value);
		return this;
	}

	/// <summary>
	/// <para>
	/// Runs once on the coordinating node after all shards have returned their results.
	/// The script is provided with access to a variable <c>states</c>, which is an array of the result of the <c>combine_script</c> on each shard.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.ScriptedMetricAggregationDescriptor<TDocument> ReduceScript(Elastic.Clients.Elasticsearch.Script? value)
	{
		Instance.ReduceScript = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Runs once on the coordinating node after all shards have returned their results.
	/// The script is provided with access to a variable <c>states</c>, which is an array of the result of the <c>combine_script</c> on each shard.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.ScriptedMetricAggregationDescriptor<TDocument> ReduceScript()
	{
		Instance.ReduceScript = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Runs once on the coordinating node after all shards have returned their results.
	/// The script is provided with access to a variable <c>states</c>, which is an array of the result of the <c>combine_script</c> on each shard.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.ScriptedMetricAggregationDescriptor<TDocument> ReduceScript(System.Action<Elastic.Clients.Elasticsearch.ScriptDescriptor>? action)
	{
		Instance.ReduceScript = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.ScriptedMetricAggregationDescriptor<TDocument> Script(Elastic.Clients.Elasticsearch.Script? value)
	{
		Instance.Script = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.ScriptedMetricAggregationDescriptor<TDocument> Script()
	{
		Instance.Script = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.ScriptedMetricAggregationDescriptor<TDocument> Script(System.Action<Elastic.Clients.Elasticsearch.ScriptDescriptor>? action)
	{
		Instance.Script = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Aggregations.ScriptedMetricAggregation Build(System.Action<Elastic.Clients.Elasticsearch.Aggregations.ScriptedMetricAggregationDescriptor<TDocument>>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Aggregations.ScriptedMetricAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Aggregations.ScriptedMetricAggregationDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.Aggregations.ScriptedMetricAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct ScriptedMetricAggregationDescriptor
{
	internal Elastic.Clients.Elasticsearch.Aggregations.ScriptedMetricAggregation Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ScriptedMetricAggregationDescriptor(Elastic.Clients.Elasticsearch.Aggregations.ScriptedMetricAggregation instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ScriptedMetricAggregationDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Aggregations.ScriptedMetricAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Aggregations.ScriptedMetricAggregationDescriptor(Elastic.Clients.Elasticsearch.Aggregations.ScriptedMetricAggregation instance) => new Elastic.Clients.Elasticsearch.Aggregations.ScriptedMetricAggregationDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Aggregations.ScriptedMetricAggregation(Elastic.Clients.Elasticsearch.Aggregations.ScriptedMetricAggregationDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Runs once on each shard after document collection is complete.
	/// Allows the aggregation to consolidate the state returned from each shard.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.ScriptedMetricAggregationDescriptor CombineScript(Elastic.Clients.Elasticsearch.Script? value)
	{
		Instance.CombineScript = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Runs once on each shard after document collection is complete.
	/// Allows the aggregation to consolidate the state returned from each shard.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.ScriptedMetricAggregationDescriptor CombineScript()
	{
		Instance.CombineScript = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Runs once on each shard after document collection is complete.
	/// Allows the aggregation to consolidate the state returned from each shard.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.ScriptedMetricAggregationDescriptor CombineScript(System.Action<Elastic.Clients.Elasticsearch.ScriptDescriptor>? action)
	{
		Instance.CombineScript = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The field on which to run the aggregation.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.ScriptedMetricAggregationDescriptor Field(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field on which to run the aggregation.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.ScriptedMetricAggregationDescriptor Field<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Runs prior to any collection of documents.
	/// Allows the aggregation to set up any initial state.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.ScriptedMetricAggregationDescriptor InitScript(Elastic.Clients.Elasticsearch.Script? value)
	{
		Instance.InitScript = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Runs prior to any collection of documents.
	/// Allows the aggregation to set up any initial state.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.ScriptedMetricAggregationDescriptor InitScript()
	{
		Instance.InitScript = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Runs prior to any collection of documents.
	/// Allows the aggregation to set up any initial state.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.ScriptedMetricAggregationDescriptor InitScript(System.Action<Elastic.Clients.Elasticsearch.ScriptDescriptor>? action)
	{
		Instance.InitScript = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Run once per document collected.
	/// If no <c>combine_script</c> is specified, the resulting state needs to be stored in the <c>state</c> object.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.ScriptedMetricAggregationDescriptor MapScript(Elastic.Clients.Elasticsearch.Script? value)
	{
		Instance.MapScript = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Run once per document collected.
	/// If no <c>combine_script</c> is specified, the resulting state needs to be stored in the <c>state</c> object.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.ScriptedMetricAggregationDescriptor MapScript()
	{
		Instance.MapScript = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Run once per document collected.
	/// If no <c>combine_script</c> is specified, the resulting state needs to be stored in the <c>state</c> object.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.ScriptedMetricAggregationDescriptor MapScript(System.Action<Elastic.Clients.Elasticsearch.ScriptDescriptor>? action)
	{
		Instance.MapScript = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The value to apply to documents that do not have a value.
	/// By default, documents without a value are ignored.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.ScriptedMetricAggregationDescriptor Missing(object? value)
	{
		Instance.Missing = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A global object with script parameters for <c>init</c>, <c>map</c> and <c>combine</c> scripts.
	/// It is shared between the scripts.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.ScriptedMetricAggregationDescriptor Params(System.Collections.Generic.IDictionary<string, object>? value)
	{
		Instance.Params = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A global object with script parameters for <c>init</c>, <c>map</c> and <c>combine</c> scripts.
	/// It is shared between the scripts.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.ScriptedMetricAggregationDescriptor Params()
	{
		Instance.Params = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// A global object with script parameters for <c>init</c>, <c>map</c> and <c>combine</c> scripts.
	/// It is shared between the scripts.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.ScriptedMetricAggregationDescriptor Params(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject>? action)
	{
		Instance.Params = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.ScriptedMetricAggregationDescriptor AddParam(string key, object value)
	{
		Instance.Params ??= new System.Collections.Generic.Dictionary<string, object>();
		Instance.Params.Add(key, value);
		return this;
	}

	/// <summary>
	/// <para>
	/// Runs once on the coordinating node after all shards have returned their results.
	/// The script is provided with access to a variable <c>states</c>, which is an array of the result of the <c>combine_script</c> on each shard.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.ScriptedMetricAggregationDescriptor ReduceScript(Elastic.Clients.Elasticsearch.Script? value)
	{
		Instance.ReduceScript = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Runs once on the coordinating node after all shards have returned their results.
	/// The script is provided with access to a variable <c>states</c>, which is an array of the result of the <c>combine_script</c> on each shard.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.ScriptedMetricAggregationDescriptor ReduceScript()
	{
		Instance.ReduceScript = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Runs once on the coordinating node after all shards have returned their results.
	/// The script is provided with access to a variable <c>states</c>, which is an array of the result of the <c>combine_script</c> on each shard.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.ScriptedMetricAggregationDescriptor ReduceScript(System.Action<Elastic.Clients.Elasticsearch.ScriptDescriptor>? action)
	{
		Instance.ReduceScript = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.ScriptedMetricAggregationDescriptor Script(Elastic.Clients.Elasticsearch.Script? value)
	{
		Instance.Script = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.ScriptedMetricAggregationDescriptor Script()
	{
		Instance.Script = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.ScriptedMetricAggregationDescriptor Script(System.Action<Elastic.Clients.Elasticsearch.ScriptDescriptor>? action)
	{
		Instance.Script = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Aggregations.ScriptedMetricAggregation Build(System.Action<Elastic.Clients.Elasticsearch.Aggregations.ScriptedMetricAggregationDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Aggregations.ScriptedMetricAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Aggregations.ScriptedMetricAggregationDescriptor(new Elastic.Clients.Elasticsearch.Aggregations.ScriptedMetricAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}