// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Aggregations.Json;

public sealed partial class SamplerAggregationExecutionHintConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Aggregations.SamplerAggregationExecutionHint>
{
	private static readonly System.Text.Json.JsonEncodedText MemberBytesHash = System.Text.Json.JsonEncodedText.Encode("bytes_hash");
	private static readonly System.Text.Json.JsonEncodedText MemberGlobalOrdinals = System.Text.Json.JsonEncodedText.Encode("global_ordinals");
	private static readonly System.Text.Json.JsonEncodedText MemberMap = System.Text.Json.JsonEncodedText.Encode("map");

	public override Elastic.Clients.Elasticsearch.Aggregations.SamplerAggregationExecutionHint Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberBytesHash))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.SamplerAggregationExecutionHint.BytesHash;
		}

		if (reader.ValueTextEquals(MemberGlobalOrdinals))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.SamplerAggregationExecutionHint.GlobalOrdinals;
		}

		if (reader.ValueTextEquals(MemberMap))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.SamplerAggregationExecutionHint.Map;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberBytesHash.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.SamplerAggregationExecutionHint.BytesHash;
		}

		if (string.Equals(value, MemberGlobalOrdinals.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.SamplerAggregationExecutionHint.GlobalOrdinals;
		}

		if (string.Equals(value, MemberMap.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.SamplerAggregationExecutionHint.Map;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Aggregations.SamplerAggregationExecutionHint)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Aggregations.SamplerAggregationExecutionHint value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.Aggregations.SamplerAggregationExecutionHint.BytesHash:
				writer.WriteStringValue(MemberBytesHash);
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.SamplerAggregationExecutionHint.GlobalOrdinals:
				writer.WriteStringValue(MemberGlobalOrdinals);
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.SamplerAggregationExecutionHint.Map:
				writer.WriteStringValue(MemberMap);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Aggregations.SamplerAggregationExecutionHint)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.Aggregations.SamplerAggregationExecutionHint ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Aggregations.SamplerAggregationExecutionHint value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}