// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Aggregations;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Aggregations.Json.SamplerAggregationConverter))]
public sealed partial class SamplerAggregation
{
#if NET7_0_OR_GREATER
	public SamplerAggregation()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public SamplerAggregation()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal SamplerAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Limits how many top-scoring documents are collected in the sample processed on each shard.
	/// </para>
	/// </summary>
	public int? ShardSize { get; set; }
}

public readonly partial struct SamplerAggregationDescriptor
{
	internal Elastic.Clients.Elasticsearch.Aggregations.SamplerAggregation Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SamplerAggregationDescriptor(Elastic.Clients.Elasticsearch.Aggregations.SamplerAggregation instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SamplerAggregationDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Aggregations.SamplerAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Aggregations.SamplerAggregationDescriptor(Elastic.Clients.Elasticsearch.Aggregations.SamplerAggregation instance) => new Elastic.Clients.Elasticsearch.Aggregations.SamplerAggregationDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Aggregations.SamplerAggregation(Elastic.Clients.Elasticsearch.Aggregations.SamplerAggregationDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Limits how many top-scoring documents are collected in the sample processed on each shard.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.SamplerAggregationDescriptor ShardSize(int? value)
	{
		Instance.ShardSize = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Aggregations.SamplerAggregation Build(System.Action<Elastic.Clients.Elasticsearch.Aggregations.SamplerAggregationDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Aggregations.SamplerAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Aggregations.SamplerAggregationDescriptor(new Elastic.Clients.Elasticsearch.Aggregations.SamplerAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}