// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Aggregations;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Aggregations.Json.RareTermsAggregationConverter))]
public sealed partial class RareTermsAggregation
{
#if NET7_0_OR_GREATER
	public RareTermsAggregation()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public RareTermsAggregation()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal RareTermsAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Terms that should be excluded from the aggregation.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.TermsExclude? Exclude { get; set; }

	/// <summary>
	/// <para>
	/// The field from which to return rare terms.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Field? Field { get; set; }

	/// <summary>
	/// <para>
	/// Terms that should be included in the aggregation.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.TermsInclude? Include { get; set; }

	/// <summary>
	/// <para>
	/// The maximum number of documents a term should appear in.
	/// </para>
	/// </summary>
	public long? MaxDocCount { get; set; }

	/// <summary>
	/// <para>
	/// The value to apply to documents that do not have a value.
	/// By default, documents without a value are ignored.
	/// </para>
	/// </summary>
	public object? Missing { get; set; }

	/// <summary>
	/// <para>
	/// The precision of the internal CuckooFilters.
	/// Smaller precision leads to better approximation, but higher memory usage.
	/// </para>
	/// </summary>
	public double? Precision { get; set; }
	public string? ValueType { get; set; }
}

public readonly partial struct RareTermsAggregationDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.Aggregations.RareTermsAggregation Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RareTermsAggregationDescriptor(Elastic.Clients.Elasticsearch.Aggregations.RareTermsAggregation instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RareTermsAggregationDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Aggregations.RareTermsAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Aggregations.RareTermsAggregationDescriptor<TDocument>(Elastic.Clients.Elasticsearch.Aggregations.RareTermsAggregation instance) => new Elastic.Clients.Elasticsearch.Aggregations.RareTermsAggregationDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Aggregations.RareTermsAggregation(Elastic.Clients.Elasticsearch.Aggregations.RareTermsAggregationDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Terms that should be excluded from the aggregation.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.RareTermsAggregationDescriptor<TDocument> Exclude(Elastic.Clients.Elasticsearch.Aggregations.TermsExclude? value)
	{
		Instance.Exclude = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field from which to return rare terms.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.RareTermsAggregationDescriptor<TDocument> Field(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field from which to return rare terms.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.RareTermsAggregationDescriptor<TDocument> Field(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Terms that should be included in the aggregation.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.RareTermsAggregationDescriptor<TDocument> Include(Elastic.Clients.Elasticsearch.Aggregations.TermsInclude? value)
	{
		Instance.Include = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The maximum number of documents a term should appear in.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.RareTermsAggregationDescriptor<TDocument> MaxDocCount(long? value)
	{
		Instance.MaxDocCount = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The value to apply to documents that do not have a value.
	/// By default, documents without a value are ignored.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.RareTermsAggregationDescriptor<TDocument> Missing(object? value)
	{
		Instance.Missing = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The precision of the internal CuckooFilters.
	/// Smaller precision leads to better approximation, but higher memory usage.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.RareTermsAggregationDescriptor<TDocument> Precision(double? value)
	{
		Instance.Precision = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.RareTermsAggregationDescriptor<TDocument> ValueType(string? value)
	{
		Instance.ValueType = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Aggregations.RareTermsAggregation Build(System.Action<Elastic.Clients.Elasticsearch.Aggregations.RareTermsAggregationDescriptor<TDocument>>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Aggregations.RareTermsAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Aggregations.RareTermsAggregationDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.Aggregations.RareTermsAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct RareTermsAggregationDescriptor
{
	internal Elastic.Clients.Elasticsearch.Aggregations.RareTermsAggregation Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RareTermsAggregationDescriptor(Elastic.Clients.Elasticsearch.Aggregations.RareTermsAggregation instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RareTermsAggregationDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Aggregations.RareTermsAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Aggregations.RareTermsAggregationDescriptor(Elastic.Clients.Elasticsearch.Aggregations.RareTermsAggregation instance) => new Elastic.Clients.Elasticsearch.Aggregations.RareTermsAggregationDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Aggregations.RareTermsAggregation(Elastic.Clients.Elasticsearch.Aggregations.RareTermsAggregationDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Terms that should be excluded from the aggregation.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.RareTermsAggregationDescriptor Exclude(Elastic.Clients.Elasticsearch.Aggregations.TermsExclude? value)
	{
		Instance.Exclude = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field from which to return rare terms.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.RareTermsAggregationDescriptor Field(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field from which to return rare terms.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.RareTermsAggregationDescriptor Field<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Terms that should be included in the aggregation.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.RareTermsAggregationDescriptor Include(Elastic.Clients.Elasticsearch.Aggregations.TermsInclude? value)
	{
		Instance.Include = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The maximum number of documents a term should appear in.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.RareTermsAggregationDescriptor MaxDocCount(long? value)
	{
		Instance.MaxDocCount = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The value to apply to documents that do not have a value.
	/// By default, documents without a value are ignored.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.RareTermsAggregationDescriptor Missing(object? value)
	{
		Instance.Missing = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The precision of the internal CuckooFilters.
	/// Smaller precision leads to better approximation, but higher memory usage.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.RareTermsAggregationDescriptor Precision(double? value)
	{
		Instance.Precision = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.RareTermsAggregationDescriptor ValueType(string? value)
	{
		Instance.ValueType = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Aggregations.RareTermsAggregation Build(System.Action<Elastic.Clients.Elasticsearch.Aggregations.RareTermsAggregationDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Aggregations.RareTermsAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Aggregations.RareTermsAggregationDescriptor(new Elastic.Clients.Elasticsearch.Aggregations.RareTermsAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}