// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Aggregations;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Aggregations.Json.RangeAggregationConverter))]
public sealed partial class RangeAggregation
{
#if NET7_0_OR_GREATER
	public RangeAggregation()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public RangeAggregation()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal RangeAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The date field whose values are use to build ranges.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Field? Field { get; set; }
	public string? Format { get; set; }

	/// <summary>
	/// <para>
	/// The value to apply to documents that do not have a value.
	/// By default, documents without a value are ignored.
	/// </para>
	/// </summary>
	public int? Missing { get; set; }

	/// <summary>
	/// <para>
	/// An array of ranges used to bucket documents.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Aggregations.AggregationRange>? Ranges { get; set; }
	public Elastic.Clients.Elasticsearch.Script? Script { get; set; }
}

public readonly partial struct RangeAggregationDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.Aggregations.RangeAggregation Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RangeAggregationDescriptor(Elastic.Clients.Elasticsearch.Aggregations.RangeAggregation instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RangeAggregationDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Aggregations.RangeAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Aggregations.RangeAggregationDescriptor<TDocument>(Elastic.Clients.Elasticsearch.Aggregations.RangeAggregation instance) => new Elastic.Clients.Elasticsearch.Aggregations.RangeAggregationDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Aggregations.RangeAggregation(Elastic.Clients.Elasticsearch.Aggregations.RangeAggregationDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The date field whose values are use to build ranges.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.RangeAggregationDescriptor<TDocument> Field(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The date field whose values are use to build ranges.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.RangeAggregationDescriptor<TDocument> Field(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.RangeAggregationDescriptor<TDocument> Format(string? value)
	{
		Instance.Format = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The value to apply to documents that do not have a value.
	/// By default, documents without a value are ignored.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.RangeAggregationDescriptor<TDocument> Missing(int? value)
	{
		Instance.Missing = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of ranges used to bucket documents.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.RangeAggregationDescriptor<TDocument> Ranges(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Aggregations.AggregationRange>? value)
	{
		Instance.Ranges = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of ranges used to bucket documents.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.RangeAggregationDescriptor<TDocument> Ranges(params Elastic.Clients.Elasticsearch.Aggregations.AggregationRange[] values)
	{
		Instance.Ranges = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of ranges used to bucket documents.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.RangeAggregationDescriptor<TDocument> Ranges(params System.Action<Elastic.Clients.Elasticsearch.Aggregations.AggregationRangeDescriptor>?[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Aggregations.AggregationRange>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Aggregations.AggregationRangeDescriptor.Build(action));
		}

		Instance.Ranges = items;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.RangeAggregationDescriptor<TDocument> Script(Elastic.Clients.Elasticsearch.Script? value)
	{
		Instance.Script = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.RangeAggregationDescriptor<TDocument> Script()
	{
		Instance.Script = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.RangeAggregationDescriptor<TDocument> Script(System.Action<Elastic.Clients.Elasticsearch.ScriptDescriptor>? action)
	{
		Instance.Script = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Aggregations.RangeAggregation Build(System.Action<Elastic.Clients.Elasticsearch.Aggregations.RangeAggregationDescriptor<TDocument>>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Aggregations.RangeAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Aggregations.RangeAggregationDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.Aggregations.RangeAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct RangeAggregationDescriptor
{
	internal Elastic.Clients.Elasticsearch.Aggregations.RangeAggregation Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RangeAggregationDescriptor(Elastic.Clients.Elasticsearch.Aggregations.RangeAggregation instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RangeAggregationDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Aggregations.RangeAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Aggregations.RangeAggregationDescriptor(Elastic.Clients.Elasticsearch.Aggregations.RangeAggregation instance) => new Elastic.Clients.Elasticsearch.Aggregations.RangeAggregationDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Aggregations.RangeAggregation(Elastic.Clients.Elasticsearch.Aggregations.RangeAggregationDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The date field whose values are use to build ranges.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.RangeAggregationDescriptor Field(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The date field whose values are use to build ranges.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.RangeAggregationDescriptor Field<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.RangeAggregationDescriptor Format(string? value)
	{
		Instance.Format = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The value to apply to documents that do not have a value.
	/// By default, documents without a value are ignored.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.RangeAggregationDescriptor Missing(int? value)
	{
		Instance.Missing = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of ranges used to bucket documents.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.RangeAggregationDescriptor Ranges(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Aggregations.AggregationRange>? value)
	{
		Instance.Ranges = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of ranges used to bucket documents.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.RangeAggregationDescriptor Ranges(params Elastic.Clients.Elasticsearch.Aggregations.AggregationRange[] values)
	{
		Instance.Ranges = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of ranges used to bucket documents.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.RangeAggregationDescriptor Ranges(params System.Action<Elastic.Clients.Elasticsearch.Aggregations.AggregationRangeDescriptor>?[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Aggregations.AggregationRange>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Aggregations.AggregationRangeDescriptor.Build(action));
		}

		Instance.Ranges = items;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.RangeAggregationDescriptor Script(Elastic.Clients.Elasticsearch.Script? value)
	{
		Instance.Script = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.RangeAggregationDescriptor Script()
	{
		Instance.Script = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.RangeAggregationDescriptor Script(System.Action<Elastic.Clients.Elasticsearch.ScriptDescriptor>? action)
	{
		Instance.Script = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Aggregations.RangeAggregation Build(System.Action<Elastic.Clients.Elasticsearch.Aggregations.RangeAggregationDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Aggregations.RangeAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Aggregations.RangeAggregationDescriptor(new Elastic.Clients.Elasticsearch.Aggregations.RangeAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}