// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Aggregations;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Aggregations.Json.RandomSamplerAggregationConverter))]
public sealed partial class RandomSamplerAggregation
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RandomSamplerAggregation(double probability)
	{
		Probability = probability;
	}
#if NET7_0_OR_GREATER
	public RandomSamplerAggregation()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public RandomSamplerAggregation()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal RandomSamplerAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The probability that a document will be included in the aggregated data.
	/// Must be greater than 0, less than 0.5, or exactly 1.
	/// The lower the probability, the fewer documents are matched.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	double Probability { get; set; }

	/// <summary>
	/// <para>
	/// The seed to generate the random sampling of documents.
	/// When a seed is provided, the random subset of documents is the same between calls.
	/// </para>
	/// </summary>
	public int? Seed { get; set; }

	/// <summary>
	/// <para>
	/// When combined with seed, setting shard_seed ensures 100% consistent sampling over shards where data is exactly the same.
	/// </para>
	/// </summary>
	public int? ShardSeed { get; set; }
}

public readonly partial struct RandomSamplerAggregationDescriptor
{
	internal Elastic.Clients.Elasticsearch.Aggregations.RandomSamplerAggregation Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RandomSamplerAggregationDescriptor(Elastic.Clients.Elasticsearch.Aggregations.RandomSamplerAggregation instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RandomSamplerAggregationDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Aggregations.RandomSamplerAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Aggregations.RandomSamplerAggregationDescriptor(Elastic.Clients.Elasticsearch.Aggregations.RandomSamplerAggregation instance) => new Elastic.Clients.Elasticsearch.Aggregations.RandomSamplerAggregationDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Aggregations.RandomSamplerAggregation(Elastic.Clients.Elasticsearch.Aggregations.RandomSamplerAggregationDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The probability that a document will be included in the aggregated data.
	/// Must be greater than 0, less than 0.5, or exactly 1.
	/// The lower the probability, the fewer documents are matched.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.RandomSamplerAggregationDescriptor Probability(double value)
	{
		Instance.Probability = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The seed to generate the random sampling of documents.
	/// When a seed is provided, the random subset of documents is the same between calls.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.RandomSamplerAggregationDescriptor Seed(int? value)
	{
		Instance.Seed = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// When combined with seed, setting shard_seed ensures 100% consistent sampling over shards where data is exactly the same.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.RandomSamplerAggregationDescriptor ShardSeed(int? value)
	{
		Instance.ShardSeed = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Aggregations.RandomSamplerAggregation Build(System.Action<Elastic.Clients.Elasticsearch.Aggregations.RandomSamplerAggregationDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Aggregations.RandomSamplerAggregationDescriptor(new Elastic.Clients.Elasticsearch.Aggregations.RandomSamplerAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}