// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Aggregations;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Aggregations.Json.PercentilesAggregationConverter))]
public sealed partial class PercentilesAggregation
{
#if NET7_0_OR_GREATER
	public PercentilesAggregation()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public PercentilesAggregation()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal PercentilesAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The field on which to run the aggregation.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Field? Field { get; set; }
	public string? Format { get; set; }

	/// <summary>
	/// <para>
	/// Uses the alternative High Dynamic Range Histogram algorithm to calculate percentiles.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.HdrMethod? Hdr { get; set; }

	/// <summary>
	/// <para>
	/// By default, the aggregation associates a unique string key with each bucket and returns the ranges as a hash rather than an array.
	/// Set to <c>false</c> to disable this behavior.
	/// </para>
	/// </summary>
	public bool? Keyed => false;

	/// <summary>
	/// <para>
	/// The value to apply to documents that do not have a value.
	/// By default, documents without a value are ignored.
	/// </para>
	/// </summary>
	public object? Missing { get; set; }

	/// <summary>
	/// <para>
	/// The percentiles to calculate.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<double>? Percents { get; set; }
	public Elastic.Clients.Elasticsearch.Script? Script { get; set; }

	/// <summary>
	/// <para>
	/// Sets parameters for the default TDigest algorithm used to calculate percentiles.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.TDigest? TDigest { get; set; }
}

public readonly partial struct PercentilesAggregationDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.Aggregations.PercentilesAggregation Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PercentilesAggregationDescriptor(Elastic.Clients.Elasticsearch.Aggregations.PercentilesAggregation instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PercentilesAggregationDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Aggregations.PercentilesAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Aggregations.PercentilesAggregationDescriptor<TDocument>(Elastic.Clients.Elasticsearch.Aggregations.PercentilesAggregation instance) => new Elastic.Clients.Elasticsearch.Aggregations.PercentilesAggregationDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Aggregations.PercentilesAggregation(Elastic.Clients.Elasticsearch.Aggregations.PercentilesAggregationDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The field on which to run the aggregation.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.PercentilesAggregationDescriptor<TDocument> Field(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field on which to run the aggregation.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.PercentilesAggregationDescriptor<TDocument> Field(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.PercentilesAggregationDescriptor<TDocument> Format(string? value)
	{
		Instance.Format = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Uses the alternative High Dynamic Range Histogram algorithm to calculate percentiles.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.PercentilesAggregationDescriptor<TDocument> Hdr(Elastic.Clients.Elasticsearch.Aggregations.HdrMethod? value)
	{
		Instance.Hdr = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Uses the alternative High Dynamic Range Histogram algorithm to calculate percentiles.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.PercentilesAggregationDescriptor<TDocument> Hdr()
	{
		Instance.Hdr = Elastic.Clients.Elasticsearch.Aggregations.HdrMethodDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Uses the alternative High Dynamic Range Histogram algorithm to calculate percentiles.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.PercentilesAggregationDescriptor<TDocument> Hdr(System.Action<Elastic.Clients.Elasticsearch.Aggregations.HdrMethodDescriptor>? action)
	{
		Instance.Hdr = Elastic.Clients.Elasticsearch.Aggregations.HdrMethodDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The value to apply to documents that do not have a value.
	/// By default, documents without a value are ignored.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.PercentilesAggregationDescriptor<TDocument> Missing(object? value)
	{
		Instance.Missing = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The percentiles to calculate.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.PercentilesAggregationDescriptor<TDocument> Percents(System.Collections.Generic.ICollection<double>? value)
	{
		Instance.Percents = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The percentiles to calculate.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.PercentilesAggregationDescriptor<TDocument> Percents(params double[] values)
	{
		Instance.Percents = [.. values];
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.PercentilesAggregationDescriptor<TDocument> Script(Elastic.Clients.Elasticsearch.Script? value)
	{
		Instance.Script = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.PercentilesAggregationDescriptor<TDocument> Script()
	{
		Instance.Script = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.PercentilesAggregationDescriptor<TDocument> Script(System.Action<Elastic.Clients.Elasticsearch.ScriptDescriptor>? action)
	{
		Instance.Script = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Sets parameters for the default TDigest algorithm used to calculate percentiles.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.PercentilesAggregationDescriptor<TDocument> TDigest(Elastic.Clients.Elasticsearch.Aggregations.TDigest? value)
	{
		Instance.TDigest = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Sets parameters for the default TDigest algorithm used to calculate percentiles.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.PercentilesAggregationDescriptor<TDocument> TDigest()
	{
		Instance.TDigest = Elastic.Clients.Elasticsearch.Aggregations.TDigestDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Sets parameters for the default TDigest algorithm used to calculate percentiles.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.PercentilesAggregationDescriptor<TDocument> TDigest(System.Action<Elastic.Clients.Elasticsearch.Aggregations.TDigestDescriptor>? action)
	{
		Instance.TDigest = Elastic.Clients.Elasticsearch.Aggregations.TDigestDescriptor.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Aggregations.PercentilesAggregation Build(System.Action<Elastic.Clients.Elasticsearch.Aggregations.PercentilesAggregationDescriptor<TDocument>>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Aggregations.PercentilesAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Aggregations.PercentilesAggregationDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.Aggregations.PercentilesAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct PercentilesAggregationDescriptor
{
	internal Elastic.Clients.Elasticsearch.Aggregations.PercentilesAggregation Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PercentilesAggregationDescriptor(Elastic.Clients.Elasticsearch.Aggregations.PercentilesAggregation instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PercentilesAggregationDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Aggregations.PercentilesAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Aggregations.PercentilesAggregationDescriptor(Elastic.Clients.Elasticsearch.Aggregations.PercentilesAggregation instance) => new Elastic.Clients.Elasticsearch.Aggregations.PercentilesAggregationDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Aggregations.PercentilesAggregation(Elastic.Clients.Elasticsearch.Aggregations.PercentilesAggregationDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The field on which to run the aggregation.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.PercentilesAggregationDescriptor Field(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field on which to run the aggregation.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.PercentilesAggregationDescriptor Field<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.PercentilesAggregationDescriptor Format(string? value)
	{
		Instance.Format = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Uses the alternative High Dynamic Range Histogram algorithm to calculate percentiles.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.PercentilesAggregationDescriptor Hdr(Elastic.Clients.Elasticsearch.Aggregations.HdrMethod? value)
	{
		Instance.Hdr = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Uses the alternative High Dynamic Range Histogram algorithm to calculate percentiles.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.PercentilesAggregationDescriptor Hdr()
	{
		Instance.Hdr = Elastic.Clients.Elasticsearch.Aggregations.HdrMethodDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Uses the alternative High Dynamic Range Histogram algorithm to calculate percentiles.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.PercentilesAggregationDescriptor Hdr(System.Action<Elastic.Clients.Elasticsearch.Aggregations.HdrMethodDescriptor>? action)
	{
		Instance.Hdr = Elastic.Clients.Elasticsearch.Aggregations.HdrMethodDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The value to apply to documents that do not have a value.
	/// By default, documents without a value are ignored.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.PercentilesAggregationDescriptor Missing(object? value)
	{
		Instance.Missing = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The percentiles to calculate.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.PercentilesAggregationDescriptor Percents(System.Collections.Generic.ICollection<double>? value)
	{
		Instance.Percents = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The percentiles to calculate.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.PercentilesAggregationDescriptor Percents(params double[] values)
	{
		Instance.Percents = [.. values];
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.PercentilesAggregationDescriptor Script(Elastic.Clients.Elasticsearch.Script? value)
	{
		Instance.Script = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.PercentilesAggregationDescriptor Script()
	{
		Instance.Script = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.PercentilesAggregationDescriptor Script(System.Action<Elastic.Clients.Elasticsearch.ScriptDescriptor>? action)
	{
		Instance.Script = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Sets parameters for the default TDigest algorithm used to calculate percentiles.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.PercentilesAggregationDescriptor TDigest(Elastic.Clients.Elasticsearch.Aggregations.TDigest? value)
	{
		Instance.TDigest = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Sets parameters for the default TDigest algorithm used to calculate percentiles.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.PercentilesAggregationDescriptor TDigest()
	{
		Instance.TDigest = Elastic.Clients.Elasticsearch.Aggregations.TDigestDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Sets parameters for the default TDigest algorithm used to calculate percentiles.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.PercentilesAggregationDescriptor TDigest(System.Action<Elastic.Clients.Elasticsearch.Aggregations.TDigestDescriptor>? action)
	{
		Instance.TDigest = Elastic.Clients.Elasticsearch.Aggregations.TDigestDescriptor.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Aggregations.PercentilesAggregation Build(System.Action<Elastic.Clients.Elasticsearch.Aggregations.PercentilesAggregationDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Aggregations.PercentilesAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Aggregations.PercentilesAggregationDescriptor(new Elastic.Clients.Elasticsearch.Aggregations.PercentilesAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}