// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Aggregations;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Aggregations.Json.PercentileRanksAggregationConverter))]
public sealed partial class PercentileRanksAggregation
{
#if NET7_0_OR_GREATER
	public PercentileRanksAggregation()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public PercentileRanksAggregation()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal PercentileRanksAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The field on which to run the aggregation.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Field? Field { get; set; }
	public string? Format { get; set; }

	/// <summary>
	/// <para>
	/// Uses the alternative High Dynamic Range Histogram algorithm to calculate percentile ranks.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.HdrMethod? Hdr { get; set; }

	/// <summary>
	/// <para>
	/// By default, the aggregation associates a unique string key with each bucket and returns the ranges as a hash rather than an array.
	/// Set to <c>false</c> to disable this behavior.
	/// </para>
	/// </summary>
	public bool? Keyed => false;

	/// <summary>
	/// <para>
	/// The value to apply to documents that do not have a value.
	/// By default, documents without a value are ignored.
	/// </para>
	/// </summary>
	public object? Missing { get; set; }
	public Elastic.Clients.Elasticsearch.Script? Script { get; set; }

	/// <summary>
	/// <para>
	/// Sets parameters for the default TDigest algorithm used to calculate percentile ranks.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.TDigest? TDigest { get; set; }

	/// <summary>
	/// <para>
	/// An array of values for which to calculate the percentile ranks.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<double>? Values { get; set; }
}

public readonly partial struct PercentileRanksAggregationDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.Aggregations.PercentileRanksAggregation Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PercentileRanksAggregationDescriptor(Elastic.Clients.Elasticsearch.Aggregations.PercentileRanksAggregation instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PercentileRanksAggregationDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Aggregations.PercentileRanksAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Aggregations.PercentileRanksAggregationDescriptor<TDocument>(Elastic.Clients.Elasticsearch.Aggregations.PercentileRanksAggregation instance) => new Elastic.Clients.Elasticsearch.Aggregations.PercentileRanksAggregationDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Aggregations.PercentileRanksAggregation(Elastic.Clients.Elasticsearch.Aggregations.PercentileRanksAggregationDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The field on which to run the aggregation.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.PercentileRanksAggregationDescriptor<TDocument> Field(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field on which to run the aggregation.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.PercentileRanksAggregationDescriptor<TDocument> Field(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.PercentileRanksAggregationDescriptor<TDocument> Format(string? value)
	{
		Instance.Format = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Uses the alternative High Dynamic Range Histogram algorithm to calculate percentile ranks.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.PercentileRanksAggregationDescriptor<TDocument> Hdr(Elastic.Clients.Elasticsearch.Aggregations.HdrMethod? value)
	{
		Instance.Hdr = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Uses the alternative High Dynamic Range Histogram algorithm to calculate percentile ranks.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.PercentileRanksAggregationDescriptor<TDocument> Hdr()
	{
		Instance.Hdr = Elastic.Clients.Elasticsearch.Aggregations.HdrMethodDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Uses the alternative High Dynamic Range Histogram algorithm to calculate percentile ranks.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.PercentileRanksAggregationDescriptor<TDocument> Hdr(System.Action<Elastic.Clients.Elasticsearch.Aggregations.HdrMethodDescriptor>? action)
	{
		Instance.Hdr = Elastic.Clients.Elasticsearch.Aggregations.HdrMethodDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The value to apply to documents that do not have a value.
	/// By default, documents without a value are ignored.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.PercentileRanksAggregationDescriptor<TDocument> Missing(object? value)
	{
		Instance.Missing = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.PercentileRanksAggregationDescriptor<TDocument> Script(Elastic.Clients.Elasticsearch.Script? value)
	{
		Instance.Script = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.PercentileRanksAggregationDescriptor<TDocument> Script()
	{
		Instance.Script = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.PercentileRanksAggregationDescriptor<TDocument> Script(System.Action<Elastic.Clients.Elasticsearch.ScriptDescriptor>? action)
	{
		Instance.Script = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Sets parameters for the default TDigest algorithm used to calculate percentile ranks.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.PercentileRanksAggregationDescriptor<TDocument> TDigest(Elastic.Clients.Elasticsearch.Aggregations.TDigest? value)
	{
		Instance.TDigest = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Sets parameters for the default TDigest algorithm used to calculate percentile ranks.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.PercentileRanksAggregationDescriptor<TDocument> TDigest()
	{
		Instance.TDigest = Elastic.Clients.Elasticsearch.Aggregations.TDigestDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Sets parameters for the default TDigest algorithm used to calculate percentile ranks.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.PercentileRanksAggregationDescriptor<TDocument> TDigest(System.Action<Elastic.Clients.Elasticsearch.Aggregations.TDigestDescriptor>? action)
	{
		Instance.TDigest = Elastic.Clients.Elasticsearch.Aggregations.TDigestDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of values for which to calculate the percentile ranks.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.PercentileRanksAggregationDescriptor<TDocument> Values(System.Collections.Generic.ICollection<double>? value)
	{
		Instance.Values = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Aggregations.PercentileRanksAggregation Build(System.Action<Elastic.Clients.Elasticsearch.Aggregations.PercentileRanksAggregationDescriptor<TDocument>>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Aggregations.PercentileRanksAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Aggregations.PercentileRanksAggregationDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.Aggregations.PercentileRanksAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct PercentileRanksAggregationDescriptor
{
	internal Elastic.Clients.Elasticsearch.Aggregations.PercentileRanksAggregation Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PercentileRanksAggregationDescriptor(Elastic.Clients.Elasticsearch.Aggregations.PercentileRanksAggregation instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PercentileRanksAggregationDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Aggregations.PercentileRanksAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Aggregations.PercentileRanksAggregationDescriptor(Elastic.Clients.Elasticsearch.Aggregations.PercentileRanksAggregation instance) => new Elastic.Clients.Elasticsearch.Aggregations.PercentileRanksAggregationDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Aggregations.PercentileRanksAggregation(Elastic.Clients.Elasticsearch.Aggregations.PercentileRanksAggregationDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The field on which to run the aggregation.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.PercentileRanksAggregationDescriptor Field(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field on which to run the aggregation.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.PercentileRanksAggregationDescriptor Field<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.PercentileRanksAggregationDescriptor Format(string? value)
	{
		Instance.Format = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Uses the alternative High Dynamic Range Histogram algorithm to calculate percentile ranks.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.PercentileRanksAggregationDescriptor Hdr(Elastic.Clients.Elasticsearch.Aggregations.HdrMethod? value)
	{
		Instance.Hdr = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Uses the alternative High Dynamic Range Histogram algorithm to calculate percentile ranks.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.PercentileRanksAggregationDescriptor Hdr()
	{
		Instance.Hdr = Elastic.Clients.Elasticsearch.Aggregations.HdrMethodDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Uses the alternative High Dynamic Range Histogram algorithm to calculate percentile ranks.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.PercentileRanksAggregationDescriptor Hdr(System.Action<Elastic.Clients.Elasticsearch.Aggregations.HdrMethodDescriptor>? action)
	{
		Instance.Hdr = Elastic.Clients.Elasticsearch.Aggregations.HdrMethodDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The value to apply to documents that do not have a value.
	/// By default, documents without a value are ignored.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.PercentileRanksAggregationDescriptor Missing(object? value)
	{
		Instance.Missing = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.PercentileRanksAggregationDescriptor Script(Elastic.Clients.Elasticsearch.Script? value)
	{
		Instance.Script = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.PercentileRanksAggregationDescriptor Script()
	{
		Instance.Script = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.PercentileRanksAggregationDescriptor Script(System.Action<Elastic.Clients.Elasticsearch.ScriptDescriptor>? action)
	{
		Instance.Script = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Sets parameters for the default TDigest algorithm used to calculate percentile ranks.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.PercentileRanksAggregationDescriptor TDigest(Elastic.Clients.Elasticsearch.Aggregations.TDigest? value)
	{
		Instance.TDigest = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Sets parameters for the default TDigest algorithm used to calculate percentile ranks.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.PercentileRanksAggregationDescriptor TDigest()
	{
		Instance.TDigest = Elastic.Clients.Elasticsearch.Aggregations.TDigestDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Sets parameters for the default TDigest algorithm used to calculate percentile ranks.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.PercentileRanksAggregationDescriptor TDigest(System.Action<Elastic.Clients.Elasticsearch.Aggregations.TDigestDescriptor>? action)
	{
		Instance.TDigest = Elastic.Clients.Elasticsearch.Aggregations.TDigestDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of values for which to calculate the percentile ranks.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.PercentileRanksAggregationDescriptor Values(System.Collections.Generic.ICollection<double>? value)
	{
		Instance.Values = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Aggregations.PercentileRanksAggregation Build(System.Action<Elastic.Clients.Elasticsearch.Aggregations.PercentileRanksAggregationDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Aggregations.PercentileRanksAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Aggregations.PercentileRanksAggregationDescriptor(new Elastic.Clients.Elasticsearch.Aggregations.PercentileRanksAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}