// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Aggregations;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Aggregations.Json.PValueHeuristicConverter))]
public sealed partial class PValueHeuristic
{
#if NET7_0_OR_GREATER
	public PValueHeuristic()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public PValueHeuristic()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal PValueHeuristic(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	public bool? BackgroundIsSuperset { get; set; }

	/// <summary>
	/// <para>
	/// Should the results be normalized when above the given value.
	/// Allows for consistent significance results at various scales.
	/// Note: <c>0</c> is a special value which means no normalization
	/// </para>
	/// </summary>
	public long? NormalizeAbove { get; set; }
}

public readonly partial struct PValueHeuristicDescriptor
{
	internal Elastic.Clients.Elasticsearch.Aggregations.PValueHeuristic Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PValueHeuristicDescriptor(Elastic.Clients.Elasticsearch.Aggregations.PValueHeuristic instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PValueHeuristicDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Aggregations.PValueHeuristic(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Aggregations.PValueHeuristicDescriptor(Elastic.Clients.Elasticsearch.Aggregations.PValueHeuristic instance) => new Elastic.Clients.Elasticsearch.Aggregations.PValueHeuristicDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Aggregations.PValueHeuristic(Elastic.Clients.Elasticsearch.Aggregations.PValueHeuristicDescriptor descriptor) => descriptor.Instance;

	public Elastic.Clients.Elasticsearch.Aggregations.PValueHeuristicDescriptor BackgroundIsSuperset(bool? value = true)
	{
		Instance.BackgroundIsSuperset = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Should the results be normalized when above the given value.
	/// Allows for consistent significance results at various scales.
	/// Note: <c>0</c> is a special value which means no normalization
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.PValueHeuristicDescriptor NormalizeAbove(long? value)
	{
		Instance.NormalizeAbove = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Aggregations.PValueHeuristic Build(System.Action<Elastic.Clients.Elasticsearch.Aggregations.PValueHeuristicDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Aggregations.PValueHeuristic(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Aggregations.PValueHeuristicDescriptor(new Elastic.Clients.Elasticsearch.Aggregations.PValueHeuristic(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}