// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Aggregations.Json;

public sealed partial class NormalizeMethodConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Aggregations.NormalizeMethod>
{
	private static readonly System.Text.Json.JsonEncodedText MemberMean = System.Text.Json.JsonEncodedText.Encode("mean");
	private static readonly System.Text.Json.JsonEncodedText MemberPercentOfSum = System.Text.Json.JsonEncodedText.Encode("percent_of_sum");
	private static readonly System.Text.Json.JsonEncodedText MemberRescale01 = System.Text.Json.JsonEncodedText.Encode("rescale_0_1");
	private static readonly System.Text.Json.JsonEncodedText MemberRescale0100 = System.Text.Json.JsonEncodedText.Encode("rescale_0_100");
	private static readonly System.Text.Json.JsonEncodedText MemberSoftmax = System.Text.Json.JsonEncodedText.Encode("softmax");
	private static readonly System.Text.Json.JsonEncodedText MemberZScore = System.Text.Json.JsonEncodedText.Encode("z-score");

	public override Elastic.Clients.Elasticsearch.Aggregations.NormalizeMethod Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberMean))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.NormalizeMethod.Mean;
		}

		if (reader.ValueTextEquals(MemberPercentOfSum))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.NormalizeMethod.PercentOfSum;
		}

		if (reader.ValueTextEquals(MemberRescale01))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.NormalizeMethod.Rescale01;
		}

		if (reader.ValueTextEquals(MemberRescale0100))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.NormalizeMethod.Rescale0100;
		}

		if (reader.ValueTextEquals(MemberSoftmax))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.NormalizeMethod.Softmax;
		}

		if (reader.ValueTextEquals(MemberZScore))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.NormalizeMethod.ZScore;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberMean.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.NormalizeMethod.Mean;
		}

		if (string.Equals(value, MemberPercentOfSum.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.NormalizeMethod.PercentOfSum;
		}

		if (string.Equals(value, MemberRescale01.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.NormalizeMethod.Rescale01;
		}

		if (string.Equals(value, MemberRescale0100.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.NormalizeMethod.Rescale0100;
		}

		if (string.Equals(value, MemberSoftmax.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.NormalizeMethod.Softmax;
		}

		if (string.Equals(value, MemberZScore.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.NormalizeMethod.ZScore;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Aggregations.NormalizeMethod)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Aggregations.NormalizeMethod value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.Aggregations.NormalizeMethod.Mean:
				writer.WriteStringValue(MemberMean);
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.NormalizeMethod.PercentOfSum:
				writer.WriteStringValue(MemberPercentOfSum);
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.NormalizeMethod.Rescale01:
				writer.WriteStringValue(MemberRescale01);
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.NormalizeMethod.Rescale0100:
				writer.WriteStringValue(MemberRescale0100);
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.NormalizeMethod.Softmax:
				writer.WriteStringValue(MemberSoftmax);
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.NormalizeMethod.ZScore:
				writer.WriteStringValue(MemberZScore);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Aggregations.NormalizeMethod)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.Aggregations.NormalizeMethod ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Aggregations.NormalizeMethod value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}