// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Aggregations.Json;

public sealed partial class NonStationaryConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Aggregations.NonStationary>
{
	private static readonly System.Text.Json.JsonEncodedText PropPValue = System.Text.Json.JsonEncodedText.Encode("p_value");
	private static readonly System.Text.Json.JsonEncodedText PropRValue = System.Text.Json.JsonEncodedText.Encode("r_value");
	private static readonly System.Text.Json.JsonEncodedText PropTrend = System.Text.Json.JsonEncodedText.Encode("trend");

	public override Elastic.Clients.Elasticsearch.Aggregations.NonStationary Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<double> propPValue = default;
		LocalJsonValue<double> propRValue = default;
		LocalJsonValue<string> propTrend = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propPValue.TryReadProperty(ref reader, options, PropPValue, null))
			{
				continue;
			}

			if (propRValue.TryReadProperty(ref reader, options, PropRValue, null))
			{
				continue;
			}

			if (propTrend.TryReadProperty(ref reader, options, PropTrend, null))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.Aggregations.NonStationary(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			PValue = propPValue.Value,
			RValue = propRValue.Value,
			Trend = propTrend.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Aggregations.NonStationary value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropPValue, value.PValue, null, null);
		writer.WriteProperty(options, PropRValue, value.RValue, null, null);
		writer.WriteProperty(options, PropTrend, value.Trend, null, null);
		writer.WriteEndObject();
	}
}