// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Aggregations;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Aggregations.Json.MultiTermsAggregationConverter))]
public sealed partial class MultiTermsAggregation
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public MultiTermsAggregation(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Aggregations.MultiTermLookup> terms)
	{
		Terms = terms;
	}
#if NET7_0_OR_GREATER
	public MultiTermsAggregation()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public MultiTermsAggregation()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal MultiTermsAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Specifies the strategy for data collection.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationCollectMode? CollectMode { get; set; }

	/// <summary>
	/// <para>
	/// The minimum number of documents in a bucket for it to be returned.
	/// </para>
	/// </summary>
	public long? MinDocCount { get; set; }

	/// <summary>
	/// <para>
	/// Specifies the sort order of the buckets.
	/// Defaults to sorting by descending document count.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.SortOrder>>? Order { get; set; }

	/// <summary>
	/// <para>
	/// The minimum number of documents in a bucket on each shard for it to be returned.
	/// </para>
	/// </summary>
	public long? ShardMinDocCount { get; set; }

	/// <summary>
	/// <para>
	/// The number of candidate terms produced by each shard.
	/// By default, <c>shard_size</c> will be automatically estimated based on the number of shards and the <c>size</c> parameter.
	/// </para>
	/// </summary>
	public int? ShardSize { get; set; }

	/// <summary>
	/// <para>
	/// Calculates the doc count error on per term basis.
	/// </para>
	/// </summary>
	public bool? ShowTermDocCountError { get; set; }

	/// <summary>
	/// <para>
	/// The number of term buckets should be returned out of the overall terms list.
	/// </para>
	/// </summary>
	public int? Size { get; set; }

	/// <summary>
	/// <para>
	/// The field from which to generate sets of terms.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Aggregations.MultiTermLookup> Terms { get; set; }
}

public readonly partial struct MultiTermsAggregationDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.Aggregations.MultiTermsAggregation Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public MultiTermsAggregationDescriptor(Elastic.Clients.Elasticsearch.Aggregations.MultiTermsAggregation instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public MultiTermsAggregationDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Aggregations.MultiTermsAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Aggregations.MultiTermsAggregationDescriptor<TDocument>(Elastic.Clients.Elasticsearch.Aggregations.MultiTermsAggregation instance) => new Elastic.Clients.Elasticsearch.Aggregations.MultiTermsAggregationDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Aggregations.MultiTermsAggregation(Elastic.Clients.Elasticsearch.Aggregations.MultiTermsAggregationDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Specifies the strategy for data collection.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.MultiTermsAggregationDescriptor<TDocument> CollectMode(Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationCollectMode? value)
	{
		Instance.CollectMode = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The minimum number of documents in a bucket for it to be returned.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.MultiTermsAggregationDescriptor<TDocument> MinDocCount(long? value)
	{
		Instance.MinDocCount = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies the sort order of the buckets.
	/// Defaults to sorting by descending document count.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.MultiTermsAggregationDescriptor<TDocument> Order(System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.SortOrder>>? value)
	{
		Instance.Order = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies the sort order of the buckets.
	/// Defaults to sorting by descending document count.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.MultiTermsAggregationDescriptor<TDocument> Order()
	{
		Instance.Order = Elastic.Clients.Elasticsearch.Fluent.FluentCollectionOfKeyValuePairOfFieldSortOrder<TDocument>.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies the sort order of the buckets.
	/// Defaults to sorting by descending document count.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.MultiTermsAggregationDescriptor<TDocument> Order(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentCollectionOfKeyValuePairOfFieldSortOrder<TDocument>>? action)
	{
		Instance.Order = Elastic.Clients.Elasticsearch.Fluent.FluentCollectionOfKeyValuePairOfFieldSortOrder<TDocument>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.MultiTermsAggregationDescriptor<TDocument> AddOrder(Elastic.Clients.Elasticsearch.Field key, Elastic.Clients.Elasticsearch.SortOrder value)
	{
		Instance.Order ??= new System.Collections.Generic.List<System.Collections.Generic.KeyValuePair<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.SortOrder>>();
		Instance.Order.Add(new System.Collections.Generic.KeyValuePair<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.SortOrder>(key, value));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.MultiTermsAggregationDescriptor<TDocument> AddOrder(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, Elastic.Clients.Elasticsearch.SortOrder value)
	{
		Instance.Order ??= new System.Collections.Generic.List<System.Collections.Generic.KeyValuePair<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.SortOrder>>();
		Instance.Order.Add(new System.Collections.Generic.KeyValuePair<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.SortOrder>(key, value));
		return this;
	}

	/// <summary>
	/// <para>
	/// The minimum number of documents in a bucket on each shard for it to be returned.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.MultiTermsAggregationDescriptor<TDocument> ShardMinDocCount(long? value)
	{
		Instance.ShardMinDocCount = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The number of candidate terms produced by each shard.
	/// By default, <c>shard_size</c> will be automatically estimated based on the number of shards and the <c>size</c> parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.MultiTermsAggregationDescriptor<TDocument> ShardSize(int? value)
	{
		Instance.ShardSize = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Calculates the doc count error on per term basis.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.MultiTermsAggregationDescriptor<TDocument> ShowTermDocCountError(bool? value = true)
	{
		Instance.ShowTermDocCountError = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The number of term buckets should be returned out of the overall terms list.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.MultiTermsAggregationDescriptor<TDocument> Size(int? value)
	{
		Instance.Size = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field from which to generate sets of terms.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.MultiTermsAggregationDescriptor<TDocument> Terms(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Aggregations.MultiTermLookup> value)
	{
		Instance.Terms = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field from which to generate sets of terms.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.MultiTermsAggregationDescriptor<TDocument> Terms(params Elastic.Clients.Elasticsearch.Aggregations.MultiTermLookup[] values)
	{
		Instance.Terms = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// The field from which to generate sets of terms.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.MultiTermsAggregationDescriptor<TDocument> Terms(params System.Action<Elastic.Clients.Elasticsearch.Aggregations.MultiTermLookupDescriptor<TDocument>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Aggregations.MultiTermLookup>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Aggregations.MultiTermLookupDescriptor<TDocument>.Build(action));
		}

		Instance.Terms = items;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Aggregations.MultiTermsAggregation Build(System.Action<Elastic.Clients.Elasticsearch.Aggregations.MultiTermsAggregationDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Aggregations.MultiTermsAggregationDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.Aggregations.MultiTermsAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct MultiTermsAggregationDescriptor
{
	internal Elastic.Clients.Elasticsearch.Aggregations.MultiTermsAggregation Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public MultiTermsAggregationDescriptor(Elastic.Clients.Elasticsearch.Aggregations.MultiTermsAggregation instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public MultiTermsAggregationDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Aggregations.MultiTermsAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Aggregations.MultiTermsAggregationDescriptor(Elastic.Clients.Elasticsearch.Aggregations.MultiTermsAggregation instance) => new Elastic.Clients.Elasticsearch.Aggregations.MultiTermsAggregationDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Aggregations.MultiTermsAggregation(Elastic.Clients.Elasticsearch.Aggregations.MultiTermsAggregationDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Specifies the strategy for data collection.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.MultiTermsAggregationDescriptor CollectMode(Elastic.Clients.Elasticsearch.Aggregations.TermsAggregationCollectMode? value)
	{
		Instance.CollectMode = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The minimum number of documents in a bucket for it to be returned.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.MultiTermsAggregationDescriptor MinDocCount(long? value)
	{
		Instance.MinDocCount = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies the sort order of the buckets.
	/// Defaults to sorting by descending document count.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.MultiTermsAggregationDescriptor Order(System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.SortOrder>>? value)
	{
		Instance.Order = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies the sort order of the buckets.
	/// Defaults to sorting by descending document count.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.MultiTermsAggregationDescriptor Order()
	{
		Instance.Order = Elastic.Clients.Elasticsearch.Fluent.FluentCollectionOfKeyValuePairOfFieldSortOrder.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies the sort order of the buckets.
	/// Defaults to sorting by descending document count.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.MultiTermsAggregationDescriptor Order(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentCollectionOfKeyValuePairOfFieldSortOrder>? action)
	{
		Instance.Order = Elastic.Clients.Elasticsearch.Fluent.FluentCollectionOfKeyValuePairOfFieldSortOrder.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies the sort order of the buckets.
	/// Defaults to sorting by descending document count.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.MultiTermsAggregationDescriptor Order<T>(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentCollectionOfKeyValuePairOfFieldSortOrder<T>>? action)
	{
		Instance.Order = Elastic.Clients.Elasticsearch.Fluent.FluentCollectionOfKeyValuePairOfFieldSortOrder<T>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.MultiTermsAggregationDescriptor AddOrder(Elastic.Clients.Elasticsearch.Field key, Elastic.Clients.Elasticsearch.SortOrder value)
	{
		Instance.Order ??= new System.Collections.Generic.List<System.Collections.Generic.KeyValuePair<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.SortOrder>>();
		Instance.Order.Add(new System.Collections.Generic.KeyValuePair<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.SortOrder>(key, value));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Aggregations.MultiTermsAggregationDescriptor AddOrder<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, Elastic.Clients.Elasticsearch.SortOrder value)
	{
		Instance.Order ??= new System.Collections.Generic.List<System.Collections.Generic.KeyValuePair<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.SortOrder>>();
		Instance.Order.Add(new System.Collections.Generic.KeyValuePair<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.SortOrder>(key, value));
		return this;
	}

	/// <summary>
	/// <para>
	/// The minimum number of documents in a bucket on each shard for it to be returned.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.MultiTermsAggregationDescriptor ShardMinDocCount(long? value)
	{
		Instance.ShardMinDocCount = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The number of candidate terms produced by each shard.
	/// By default, <c>shard_size</c> will be automatically estimated based on the number of shards and the <c>size</c> parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.MultiTermsAggregationDescriptor ShardSize(int? value)
	{
		Instance.ShardSize = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Calculates the doc count error on per term basis.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.MultiTermsAggregationDescriptor ShowTermDocCountError(bool? value = true)
	{
		Instance.ShowTermDocCountError = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The number of term buckets should be returned out of the overall terms list.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.MultiTermsAggregationDescriptor Size(int? value)
	{
		Instance.Size = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field from which to generate sets of terms.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.MultiTermsAggregationDescriptor Terms(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Aggregations.MultiTermLookup> value)
	{
		Instance.Terms = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field from which to generate sets of terms.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.MultiTermsAggregationDescriptor Terms(params Elastic.Clients.Elasticsearch.Aggregations.MultiTermLookup[] values)
	{
		Instance.Terms = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// The field from which to generate sets of terms.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.MultiTermsAggregationDescriptor Terms(params System.Action<Elastic.Clients.Elasticsearch.Aggregations.MultiTermLookupDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Aggregations.MultiTermLookup>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Aggregations.MultiTermLookupDescriptor.Build(action));
		}

		Instance.Terms = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field from which to generate sets of terms.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.MultiTermsAggregationDescriptor Terms<T>(params System.Action<Elastic.Clients.Elasticsearch.Aggregations.MultiTermLookupDescriptor<T>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Aggregations.MultiTermLookup>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Aggregations.MultiTermLookupDescriptor<T>.Build(action));
		}

		Instance.Terms = items;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Aggregations.MultiTermsAggregation Build(System.Action<Elastic.Clients.Elasticsearch.Aggregations.MultiTermsAggregationDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Aggregations.MultiTermsAggregationDescriptor(new Elastic.Clients.Elasticsearch.Aggregations.MultiTermsAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}