// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Aggregations;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Aggregations.Json.MultiTermLookupConverter))]
public sealed partial class MultiTermLookup
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public MultiTermLookup(Elastic.Clients.Elasticsearch.Field field)
	{
		Field = field;
	}
#if NET7_0_OR_GREATER
	public MultiTermLookup()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public MultiTermLookup()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal MultiTermLookup(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// A fields from which to retrieve terms.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Field Field { get; set; }

	/// <summary>
	/// <para>
	/// The value to apply to documents that do not have a value.
	/// By default, documents without a value are ignored.
	/// </para>
	/// </summary>
	public object? Missing { get; set; }
}

public readonly partial struct MultiTermLookupDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.Aggregations.MultiTermLookup Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public MultiTermLookupDescriptor(Elastic.Clients.Elasticsearch.Aggregations.MultiTermLookup instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public MultiTermLookupDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Aggregations.MultiTermLookup(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Aggregations.MultiTermLookupDescriptor<TDocument>(Elastic.Clients.Elasticsearch.Aggregations.MultiTermLookup instance) => new Elastic.Clients.Elasticsearch.Aggregations.MultiTermLookupDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Aggregations.MultiTermLookup(Elastic.Clients.Elasticsearch.Aggregations.MultiTermLookupDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// A fields from which to retrieve terms.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.MultiTermLookupDescriptor<TDocument> Field(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A fields from which to retrieve terms.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.MultiTermLookupDescriptor<TDocument> Field(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The value to apply to documents that do not have a value.
	/// By default, documents without a value are ignored.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.MultiTermLookupDescriptor<TDocument> Missing(object? value)
	{
		Instance.Missing = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Aggregations.MultiTermLookup Build(System.Action<Elastic.Clients.Elasticsearch.Aggregations.MultiTermLookupDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Aggregations.MultiTermLookupDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.Aggregations.MultiTermLookup(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct MultiTermLookupDescriptor
{
	internal Elastic.Clients.Elasticsearch.Aggregations.MultiTermLookup Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public MultiTermLookupDescriptor(Elastic.Clients.Elasticsearch.Aggregations.MultiTermLookup instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public MultiTermLookupDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Aggregations.MultiTermLookup(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Aggregations.MultiTermLookupDescriptor(Elastic.Clients.Elasticsearch.Aggregations.MultiTermLookup instance) => new Elastic.Clients.Elasticsearch.Aggregations.MultiTermLookupDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Aggregations.MultiTermLookup(Elastic.Clients.Elasticsearch.Aggregations.MultiTermLookupDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// A fields from which to retrieve terms.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.MultiTermLookupDescriptor Field(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A fields from which to retrieve terms.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.MultiTermLookupDescriptor Field<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The value to apply to documents that do not have a value.
	/// By default, documents without a value are ignored.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.MultiTermLookupDescriptor Missing(object? value)
	{
		Instance.Missing = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Aggregations.MultiTermLookup Build(System.Action<Elastic.Clients.Elasticsearch.Aggregations.MultiTermLookupDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Aggregations.MultiTermLookupDescriptor(new Elastic.Clients.Elasticsearch.Aggregations.MultiTermLookup(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}