// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Aggregations;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Aggregations.Json.MovingPercentilesAggregationConverter))]
public sealed partial class MovingPercentilesAggregation
{
#if NET7_0_OR_GREATER
	public MovingPercentilesAggregation()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public MovingPercentilesAggregation()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal MovingPercentilesAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Path to the buckets that contain one set of values to correlate.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.BucketsPath? BucketsPath { get; set; }

	/// <summary>
	/// <para>
	/// <c>DecimalFormat</c> pattern for the output value.
	/// If specified, the formatted value is returned in the aggregation’s <c>value_as_string</c> property.
	/// </para>
	/// </summary>
	public string? Format { get; set; }

	/// <summary>
	/// <para>
	/// Policy to apply when gaps are found in the data.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.GapPolicy? GapPolicy { get; set; }

	public bool? Keyed => false;

	/// <summary>
	/// <para>
	/// By default, the window consists of the last n values excluding the current bucket.
	/// Increasing <c>shift</c> by 1, moves the starting window position by 1 to the right.
	/// </para>
	/// </summary>
	public int? Shift { get; set; }

	/// <summary>
	/// <para>
	/// The size of window to "slide" across the histogram.
	/// </para>
	/// </summary>
	public int? Window { get; set; }
}

public readonly partial struct MovingPercentilesAggregationDescriptor
{
	internal Elastic.Clients.Elasticsearch.Aggregations.MovingPercentilesAggregation Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public MovingPercentilesAggregationDescriptor(Elastic.Clients.Elasticsearch.Aggregations.MovingPercentilesAggregation instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public MovingPercentilesAggregationDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Aggregations.MovingPercentilesAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Aggregations.MovingPercentilesAggregationDescriptor(Elastic.Clients.Elasticsearch.Aggregations.MovingPercentilesAggregation instance) => new Elastic.Clients.Elasticsearch.Aggregations.MovingPercentilesAggregationDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Aggregations.MovingPercentilesAggregation(Elastic.Clients.Elasticsearch.Aggregations.MovingPercentilesAggregationDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Path to the buckets that contain one set of values to correlate.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.MovingPercentilesAggregationDescriptor BucketsPath(Elastic.Clients.Elasticsearch.Aggregations.BucketsPath? value)
	{
		Instance.BucketsPath = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// <c>DecimalFormat</c> pattern for the output value.
	/// If specified, the formatted value is returned in the aggregation’s <c>value_as_string</c> property.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.MovingPercentilesAggregationDescriptor Format(string? value)
	{
		Instance.Format = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Policy to apply when gaps are found in the data.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.MovingPercentilesAggregationDescriptor GapPolicy(Elastic.Clients.Elasticsearch.Aggregations.GapPolicy? value)
	{
		Instance.GapPolicy = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// By default, the window consists of the last n values excluding the current bucket.
	/// Increasing <c>shift</c> by 1, moves the starting window position by 1 to the right.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.MovingPercentilesAggregationDescriptor Shift(int? value)
	{
		Instance.Shift = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The size of window to "slide" across the histogram.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.MovingPercentilesAggregationDescriptor Window(int? value)
	{
		Instance.Window = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Aggregations.MovingPercentilesAggregation Build(System.Action<Elastic.Clients.Elasticsearch.Aggregations.MovingPercentilesAggregationDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Aggregations.MovingPercentilesAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Aggregations.MovingPercentilesAggregationDescriptor(new Elastic.Clients.Elasticsearch.Aggregations.MovingPercentilesAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}