// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Aggregations.Json;

public sealed partial class MinimumIntervalConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Aggregations.MinimumInterval>
{
	private static readonly System.Text.Json.JsonEncodedText MemberDay = System.Text.Json.JsonEncodedText.Encode("day");
	private static readonly System.Text.Json.JsonEncodedText MemberHour = System.Text.Json.JsonEncodedText.Encode("hour");
	private static readonly System.Text.Json.JsonEncodedText MemberMinute = System.Text.Json.JsonEncodedText.Encode("minute");
	private static readonly System.Text.Json.JsonEncodedText MemberMonth = System.Text.Json.JsonEncodedText.Encode("month");
	private static readonly System.Text.Json.JsonEncodedText MemberSecond = System.Text.Json.JsonEncodedText.Encode("second");
	private static readonly System.Text.Json.JsonEncodedText MemberYear = System.Text.Json.JsonEncodedText.Encode("year");

	public override Elastic.Clients.Elasticsearch.Aggregations.MinimumInterval Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberDay))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.MinimumInterval.Day;
		}

		if (reader.ValueTextEquals(MemberHour))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.MinimumInterval.Hour;
		}

		if (reader.ValueTextEquals(MemberMinute))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.MinimumInterval.Minute;
		}

		if (reader.ValueTextEquals(MemberMonth))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.MinimumInterval.Month;
		}

		if (reader.ValueTextEquals(MemberSecond))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.MinimumInterval.Second;
		}

		if (reader.ValueTextEquals(MemberYear))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.MinimumInterval.Year;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberDay.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.MinimumInterval.Day;
		}

		if (string.Equals(value, MemberHour.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.MinimumInterval.Hour;
		}

		if (string.Equals(value, MemberMinute.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.MinimumInterval.Minute;
		}

		if (string.Equals(value, MemberMonth.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.MinimumInterval.Month;
		}

		if (string.Equals(value, MemberSecond.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.MinimumInterval.Second;
		}

		if (string.Equals(value, MemberYear.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Aggregations.MinimumInterval.Year;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Aggregations.MinimumInterval)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Aggregations.MinimumInterval value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.Aggregations.MinimumInterval.Day:
				writer.WriteStringValue(MemberDay);
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.MinimumInterval.Hour:
				writer.WriteStringValue(MemberHour);
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.MinimumInterval.Minute:
				writer.WriteStringValue(MemberMinute);
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.MinimumInterval.Month:
				writer.WriteStringValue(MemberMonth);
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.MinimumInterval.Second:
				writer.WriteStringValue(MemberSecond);
				break;
			case Elastic.Clients.Elasticsearch.Aggregations.MinimumInterval.Year:
				writer.WriteStringValue(MemberYear);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Aggregations.MinimumInterval)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.Aggregations.MinimumInterval ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Aggregations.MinimumInterval value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}