// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Aggregations.Json;

public sealed partial class MatrixStatsFieldsConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Aggregations.MatrixStatsFields>
{
	private static readonly System.Text.Json.JsonEncodedText PropCorrelation = System.Text.Json.JsonEncodedText.Encode("correlation");
	private static readonly System.Text.Json.JsonEncodedText PropCount = System.Text.Json.JsonEncodedText.Encode("count");
	private static readonly System.Text.Json.JsonEncodedText PropCovariance = System.Text.Json.JsonEncodedText.Encode("covariance");
	private static readonly System.Text.Json.JsonEncodedText PropKurtosis = System.Text.Json.JsonEncodedText.Encode("kurtosis");
	private static readonly System.Text.Json.JsonEncodedText PropMean = System.Text.Json.JsonEncodedText.Encode("mean");
	private static readonly System.Text.Json.JsonEncodedText PropName = System.Text.Json.JsonEncodedText.Encode("name");
	private static readonly System.Text.Json.JsonEncodedText PropSkewness = System.Text.Json.JsonEncodedText.Encode("skewness");
	private static readonly System.Text.Json.JsonEncodedText PropVariance = System.Text.Json.JsonEncodedText.Encode("variance");

	public override Elastic.Clients.Elasticsearch.Aggregations.MatrixStatsFields Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<System.Collections.Generic.IReadOnlyDictionary<string, double>> propCorrelation = default;
		LocalJsonValue<long> propCount = default;
		LocalJsonValue<System.Collections.Generic.IReadOnlyDictionary<string, double>> propCovariance = default;
		LocalJsonValue<double> propKurtosis = default;
		LocalJsonValue<double> propMean = default;
		LocalJsonValue<string> propName = default;
		LocalJsonValue<double> propSkewness = default;
		LocalJsonValue<double> propVariance = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propCorrelation.TryReadProperty(ref reader, options, PropCorrelation, static System.Collections.Generic.IReadOnlyDictionary<string, double> (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadDictionaryValue<string, double>(o, null, null)!))
			{
				continue;
			}

			if (propCount.TryReadProperty(ref reader, options, PropCount, null))
			{
				continue;
			}

			if (propCovariance.TryReadProperty(ref reader, options, PropCovariance, static System.Collections.Generic.IReadOnlyDictionary<string, double> (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadDictionaryValue<string, double>(o, null, null)!))
			{
				continue;
			}

			if (propKurtosis.TryReadProperty(ref reader, options, PropKurtosis, null))
			{
				continue;
			}

			if (propMean.TryReadProperty(ref reader, options, PropMean, null))
			{
				continue;
			}

			if (propName.TryReadProperty(ref reader, options, PropName, null))
			{
				continue;
			}

			if (propSkewness.TryReadProperty(ref reader, options, PropSkewness, null))
			{
				continue;
			}

			if (propVariance.TryReadProperty(ref reader, options, PropVariance, null))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.Aggregations.MatrixStatsFields(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			Correlation = propCorrelation.Value,
			Count = propCount.Value,
			Covariance = propCovariance.Value,
			Kurtosis = propKurtosis.Value,
			Mean = propMean.Value,
			Name = propName.Value,
			Skewness = propSkewness.Value,
			Variance = propVariance.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Aggregations.MatrixStatsFields value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropCorrelation, value.Correlation, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.IReadOnlyDictionary<string, double> v) => w.WriteDictionaryValue<string, double>(o, v, null, null));
		writer.WriteProperty(options, PropCount, value.Count, null, null);
		writer.WriteProperty(options, PropCovariance, value.Covariance, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.IReadOnlyDictionary<string, double> v) => w.WriteDictionaryValue<string, double>(o, v, null, null));
		writer.WriteProperty(options, PropKurtosis, value.Kurtosis, null, null);
		writer.WriteProperty(options, PropMean, value.Mean, null, null);
		writer.WriteProperty(options, PropName, value.Name, null, null);
		writer.WriteProperty(options, PropSkewness, value.Skewness, null, null);
		writer.WriteProperty(options, PropVariance, value.Variance, null, null);
		writer.WriteEndObject();
	}
}