// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Aggregations;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Aggregations.Json.IpRangeAggregationRangeConverter))]
public sealed partial class IpRangeAggregationRange
{
#if NET7_0_OR_GREATER
	public IpRangeAggregationRange()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public IpRangeAggregationRange()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal IpRangeAggregationRange(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Start of the range.
	/// </para>
	/// </summary>
	public string? From { get; set; }

	/// <summary>
	/// <para>
	/// IP range defined as a CIDR mask.
	/// </para>
	/// </summary>
	public string? Mask { get; set; }

	/// <summary>
	/// <para>
	/// End of the range.
	/// </para>
	/// </summary>
	public string? To { get; set; }
}

public readonly partial struct IpRangeAggregationRangeDescriptor
{
	internal Elastic.Clients.Elasticsearch.Aggregations.IpRangeAggregationRange Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public IpRangeAggregationRangeDescriptor(Elastic.Clients.Elasticsearch.Aggregations.IpRangeAggregationRange instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public IpRangeAggregationRangeDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Aggregations.IpRangeAggregationRange(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Aggregations.IpRangeAggregationRangeDescriptor(Elastic.Clients.Elasticsearch.Aggregations.IpRangeAggregationRange instance) => new Elastic.Clients.Elasticsearch.Aggregations.IpRangeAggregationRangeDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Aggregations.IpRangeAggregationRange(Elastic.Clients.Elasticsearch.Aggregations.IpRangeAggregationRangeDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Start of the range.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.IpRangeAggregationRangeDescriptor From(string? value)
	{
		Instance.From = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// IP range defined as a CIDR mask.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.IpRangeAggregationRangeDescriptor Mask(string? value)
	{
		Instance.Mask = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// End of the range.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.IpRangeAggregationRangeDescriptor To(string? value)
	{
		Instance.To = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Aggregations.IpRangeAggregationRange Build(System.Action<Elastic.Clients.Elasticsearch.Aggregations.IpRangeAggregationRangeDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Aggregations.IpRangeAggregationRange(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Aggregations.IpRangeAggregationRangeDescriptor(new Elastic.Clients.Elasticsearch.Aggregations.IpRangeAggregationRange(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}